/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.compat.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.recipe.BreweryRecipe;
import de.melanx.utilitix.registration.ModBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;

public class BreweryCategory
implements IRecipeCategory<BreweryRecipe> {
    public static final ResourceLocation ID = new ResourceLocation(UtilitiX.getInstance().modid, "advanced_brewery");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final Component localizedName;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated bubbles;
    private final IDrawableStatic blazeHeat;

    public BreweryCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation(UtilitiX.getInstance().modid, "textures/container/advanced_brewery.png");
        this.background = guiHelper.drawableBuilder(location, 55, 15, 64, 60).addPadding(1, 0, 0, 50).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.advancedBrewery));
        this.localizedName = new TranslatableComponent("screen.utilitix.advanced_brewery");
        this.arrow = guiHelper.drawableBuilder(location, 176, 0, 9, 28).buildAnimated(400, IDrawableAnimated.StartDirection.TOP, false);
        BubbleTimer bubblesTickTimer = new BubbleTimer(guiHelper);
        this.bubbles = guiHelper.drawableBuilder(location, 185, 0, 12, 29).buildAnimated((ITickTimer)bubblesTickTimer, IDrawableAnimated.StartDirection.BOTTOM);
        this.blazeHeat = guiHelper.createDrawable(location, 176, 29, 18, 4);
        this.slot = guiHelper.getSlotDrawable();
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ID;
    }

    @Nonnull
    public Class<? extends BreweryRecipe> getRecipeClass() {
        return BreweryRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull BreweryRecipe recipe, @Nonnull IIngredients ii) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42589_);
        PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43602_);
        ii.setInputIngredients(recipe.m_7527_());
        ii.setOutputs(VanillaTypes.ITEM, (List)ImmutableList.of((Object)stack, (Object)recipe.m_8043_()));
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull BreweryRecipe recipe, @Nonnull IIngredients ii) {
        layout.getItemStacks().init(0, false, 23, 43);
        layout.getItemStacks().init(1, true, 23, 2);
        layout.getItemStacks().init(2, false, 80, 2);
        layout.getItemStacks().setBackground(2, this.slot);
        layout.getItemStacks().set(ii);
    }

    public void draw(@Nonnull BreweryRecipe recipe, @Nonnull PoseStack poseStack, double mouseX, double mouseY) {
        this.blazeHeat.draw(poseStack, 5, 30);
        this.bubbles.draw(poseStack, 8, 0);
        this.arrow.draw(poseStack, 42, 2);
    }

    private static class BubbleTimer
    implements ITickTimer {
        private static final int[] BUBBLE_SIZES = new int[]{29, 24, 20, 16, 11, 6, 0};
        private final ITickTimer timer;

        public BubbleTimer(IGuiHelper guiHelper) {
            this.timer = guiHelper.createTickTimer(14, BUBBLE_SIZES.length - 1, false);
        }

        public int getValue() {
            return BUBBLE_SIZES[this.timer.getValue()];
        }

        public int getMaxValue() {
            return BUBBLE_SIZES[0];
        }
    }
}

