/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.compat.jei;

import com.google.common.collect.ImmutableList;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.compat.jei.BreweryCategory;
import de.melanx.utilitix.compat.jei.GildingCategory;
import de.melanx.utilitix.content.brewery.ScreenAdvancedBrewery;
import de.melanx.utilitix.content.gildingarmor.GildingArmorRecipe;
import de.melanx.utilitix.recipe.EffectTransformer;
import de.melanx.utilitix.registration.ModBlocks;
import de.melanx.utilitix.registration.ModEntities;
import de.melanx.utilitix.registration.ModItems;
import de.melanx.utilitix.registration.ModRecipes;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@JeiPlugin
public class UtiliJei
implements IModPlugin {
    private static IJeiRuntime runtime = null;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation(UtilitiX.getInstance().modid, "jeiplugin");
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new BreweryCategory(registration.getJeiHelpers().getGuiHelper()), new GildingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RecipeManager recipes = Objects.requireNonNull(level).m_7465_();
        List simpleBrewery = recipes.m_44013_(ModRecipes.BREWERY).stream().filter(r -> r.getAction() instanceof EffectTransformer.Apply).collect(Collectors.toList());
        registration.addRecipes(simpleBrewery, BreweryCategory.ID);
        registration.addRecipes(GildingArmorRecipe.getRecipes(), GildingCategory.ID);
        registration.addIngredientInfo((Object)new ItemStack(ModBlocks.advancedBrewery), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.advanced_brewery"), new TranslatableComponent("description.utilitix.advanced_brewery.brewing"), new TranslatableComponent("description.utilitix.advanced_brewery.merging"), new TranslatableComponent("description.utilitix.advanced_brewery.upgrading"), new TranslatableComponent("description.utilitix.advanced_brewery.cloning")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.comparatorRedirectorUp), (Object)new ItemStack((ItemLike)ModBlocks.comparatorRedirectorDown)), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.comparator_redirector")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.weakRedstoneTorch), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.weak_redstone_torch")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModItems.tinyCoal), (Object)new ItemStack((ItemLike)ModItems.tinyCharcoal)), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.tiny_coal")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.handBell), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.hand_bell")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.mobBell), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.mob_bell")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.failedPotion), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.failed_potion")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.armedStand), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.armed_stand")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.glueBall), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.glue_ball")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.linkedCrystal), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.linked_crystal")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.linkedRepeater), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.linked_repeater")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.minecartTinkerer), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.minecart_tinkerer")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.highspeedRail), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.highspeed_rail")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.directionalRail), (Object)new ItemStack((ItemLike)ModBlocks.directionalHighspeedRail)), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.directional_rail")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.crossingRail), (Object)new ItemStack((ItemLike)ModBlocks.reinforcedCrossingRail)), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.crossing_rail")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.filterRail), (Object)new ItemStack((ItemLike)ModBlocks.reinforcedFilterRail)), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.filter_rail")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.reinforcedRail), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.reinforced_rail")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModEntities.enderCart.item()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.ender_cart")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModEntities.pistonCart.item()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.piston_cart")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.pistonControllerRail), (Object)new ItemStack((ItemLike)ModBlocks.reinforcedPistonControllerRail)), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.piston_controller_rail")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModEntities.stonecutterCart.item()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.stonecutter_cart")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModEntities.anvilCart.item()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.anvil_cart")});
        registration.addIngredientInfo((Object)new ItemStack(ModBlocks.crudeFurnace), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.utilitix.crude_furnace")});
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.advancedBrewery), new ResourceLocation[]{BreweryCategory.ID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50625_), new ResourceLocation[]{GildingCategory.ID});
    }

    public void registerGuiHandlers(@Nonnull IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ScreenAdvancedBrewery.class, 98, 17, 7, 26, new ResourceLocation[]{BreweryCategory.ID});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }

    public static void runtime(Consumer<IJeiRuntime> action) {
        if (runtime != null) {
            action.accept(runtime);
        }
    }

    public static <T> Optional<T> runtime(Function<IJeiRuntime, T> action) {
        if (runtime != null) {
            return Optional.of(action.apply(runtime));
        }
        return Optional.empty();
    }
}

