/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.brewery;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.brewery.ContainerMenuAdvancedBrewery;
import de.melanx.utilitix.content.brewery.TileAdvancedBrewery;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;

public class ScreenAdvancedBrewery
extends AbstractContainerScreen<ContainerMenuAdvancedBrewery> {
    public static final ResourceLocation TEXTURE = new ResourceLocation(UtilitiX.getInstance().modid, "textures/container/advanced_brewery.png");
    private static final int[] BUBBLE_SIZES = new int[]{29, 24, 20, 16, 11, 6, 0};
    private int relX;
    private int relY;

    public ScreenAdvancedBrewery(ContainerMenuAdvancedBrewery menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        MinecraftForge.EVENT_BUS.addListener(this::onGuiInit);
    }

    private void onGuiInit(ScreenEvent.InitScreenEvent event) {
        this.relX = (event.getScreen().f_96543_ - this.f_97726_) / 2;
        this.relY = (event.getScreen().f_96544_ - this.f_97727_) / 2;
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(@Nonnull PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(poseStack, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        TileAdvancedBrewery tile = (TileAdvancedBrewery)((ContainerMenuAdvancedBrewery)this.f_97732_).getBlockEntity();
        int fuelWidth = Mth.m_14045_((int)Math.round((float)(18 * tile.getFuel() + 19) / 20.0f), (int)0, (int)18);
        if (tile.getFuel() > 0 && fuelWidth > 0) {
            this.m_93228_(poseStack, this.relX + 60, this.relY + 44, 176, 29, fuelWidth, 4);
        }
        int brewTime = Mth.m_14045_((int)tile.getBrewTime(), (int)0, (int)400);
        if (tile.getFuel() > 0 && brewTime > 0) {
            int textureHeight = Mth.m_14045_((int)Math.round(28.0f * ((float)brewTime / 400.0f)), (int)0, (int)28);
            if (textureHeight > 0) {
                this.m_93228_(poseStack, this.relX + 97, this.relY + 16, 176, 0, 9, textureHeight);
            }
            if ((textureHeight = BUBBLE_SIZES[(400 - brewTime) / 2 % BUBBLE_SIZES.length]) > 0) {
                this.m_93228_(poseStack, this.relX + 63, this.relY + 14 + 29 - textureHeight, 185, 29 - textureHeight, 12, textureHeight);
            }
        }
    }

    protected void m_7027_(@Nonnull PoseStack poseStack, int mouseX, int mouseY) {
        String s = this.f_96539_.getString();
        this.f_96547_.m_92883_(poseStack, s, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(s) / 2), 5.0f, Color.DARK_GRAY.getRGB());
        this.f_96547_.m_92889_(poseStack, this.f_169604_, 8.0f, (float)(this.f_97727_ - 94), Color.DARK_GRAY.getRGB());
    }
}

