/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.experiencecrystal;

import de.melanx.utilitix.UtilitiXConfig;
import de.melanx.utilitix.util.BoundingBoxUtils;
import io.github.noeppi_noeppi.libx.base.tile.BlockEntityBase;
import io.github.noeppi_noeppi.libx.base.tile.TickableBlock;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TileExperienceCrystal
extends BlockEntityBase
implements TickableBlock {
    private int xp;

    public TileExperienceCrystal(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
    }

    public void tick() {
        if (this.f_58857_ != null) {
            this.moveExps(this.f_58857_, this.f_58858_);
        }
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.xp = nbt.m_128451_("Xp");
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        compound.m_128405_("Xp", this.xp);
    }

    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        this.xp = nbt.m_128451_("Xp");
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("Xp", this.xp);
        return nbt;
    }

    public int getXp() {
        return this.xp;
    }

    public int addXp(int xp) {
        int add = Math.min(Math.max(0, xp), UtilitiXConfig.ExperienceCrystal.maxXp - this.xp);
        this.xp += add;
        this.m_6596_();
        this.setDispatchable();
        return add;
    }

    public int subtractXp(int xp) {
        int remove = Math.max(0, Math.min(xp, this.xp));
        this.xp -= remove;
        this.m_6596_();
        this.setDispatchable();
        return remove;
    }

    private void moveExps(Level level, BlockPos pos) {
        if (!UtilitiXConfig.ExperienceCrystal.pullOrbs || this.xp >= UtilitiXConfig.ExperienceCrystal.maxXp) {
            return;
        }
        List xps = level.m_45976_(ExperienceOrb.class, BoundingBoxUtils.expand(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), 7.0));
        for (ExperienceOrb orb : xps) {
            Vec3 vector = new Vec3((double)pos.m_123341_() - orb.m_20185_() + 0.5, (double)((float)pos.m_123342_() + orb.m_20192_() / 2.0f) - orb.m_20186_(), (double)pos.m_123343_() - orb.m_20189_() + 0.5);
            double scale = 1.0 - vector.m_82553_() / 8.0;
            orb.m_20256_(orb.m_20184_().m_82549_(vector.m_82541_().m_82490_(scale * scale * 0.1)));
        }
    }
}

