/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.slime;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.slime.StickyChunk;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class SlimyCapability {
    public static final ResourceLocation KEY = new ResourceLocation(UtilitiX.getInstance().modid, "sticky_chunk");
    public static Capability<StickyChunk> STICKY_CHUNK;

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.register(StickyChunk.class);
        STICKY_CHUNK = CapabilityManager.get((CapabilityToken)new CapabilityToken<StickyChunk>(){});
    }

    public static void attach(AttachCapabilitiesEvent<LevelChunk> event) {
        if (!event.getCapabilities().containsKey(KEY)) {
            LazyValue capInstance = new LazyValue(() -> {
                StickyChunk instance = new StickyChunk();
                instance.attach((LevelChunk)event.getObject());
                return instance;
            });
            event.addCapability(KEY, (ICapabilityProvider)new SimpleProvider(STICKY_CHUNK, capInstance));
        } else {
            ((ICapabilityProvider)event.getCapabilities().get(KEY)).getCapability(STICKY_CHUNK).ifPresent(s -> s.attach((LevelChunk)event.getObject()));
        }
    }

    public static boolean canGlue(Level level, BlockPos pos, Direction side) {
        BlockState state = level.m_8055_(pos);
        return state.m_60783_((BlockGetter)level, pos, side) && !state.isStickyBlock() && state.m_60800_((BlockGetter)level, pos) >= 0.0f;
    }

    public static class SimpleProvider
    implements ICapabilityProvider,
    INBTSerializable<Tag> {
        public final Capability<?> capability;
        public final LazyValue<?> value;

        public <T> SimpleProvider(Capability<T> capability, LazyValue<? extends T> value) {
            this.capability = capability;
            this.value = value;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == this.capability ? LazyOptional.of(() -> this.value.get()).cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return new ByteArrayTag(((StickyChunk)this.value.get()).getStickies());
        }

        public void deserializeNBT(Tag nbt) {
            ((StickyChunk)this.value.get()).setStickies(((ByteArrayTag)nbt).m_128227_());
        }
    }
}

