/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.slime;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.network.StickyChunkUpdateSerializer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;

public class StickyChunk {
    @Nullable
    private LevelChunk chunk;
    private byte[] stickies = new byte[65536];
    private Set<Integer> indicesWithGlue = null;

    public boolean get(int x, int y, int z, Direction dir) {
        int idx = (y & 0xFF) << 8 | (z & 0xF) << 4 | x & 0xF;
        byte data = this.stickies[idx];
        return (data & 1 << dir.ordinal()) != 0;
    }

    public void set(int x, int y, int z, Direction dir, boolean sticky) {
        int idx = (y & 0xFF) << 8 | (z & 0xF) << 4 | x & 0xF;
        this.stickies[idx] = sticky ? (byte)(this.stickies[idx] | (byte)(1 << dir.ordinal())) : (byte)(this.stickies[idx] & ~((byte)(1 << dir.ordinal())));
        this.indicesWithGlue = null;
        if (this.chunk != null && !this.chunk.m_62953_().f_46443_) {
            this.chunk.m_8092_(true);
            UtilitiX.getNetwork().channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.chunk), (Object)new StickyChunkUpdateSerializer.StickyChunkUpdateMessage(this.chunk.m_7697_(), this));
        }
    }

    public byte getData(int x, int y, int z) {
        int idx = (y & 0xFF) << 8 | (z & 0xF) << 4 | x & 0xF;
        return this.stickies[idx];
    }

    public void setData(int x, int y, int z, byte data) {
        int idx = (y & 0xFF) << 8 | (z & 0xF) << 4 | x & 0xF;
        this.stickies[idx] = data;
        this.indicesWithGlue = null;
        if (this.chunk != null && !this.chunk.m_62953_().f_46443_) {
            this.chunk.m_8092_(true);
            UtilitiX.getNetwork().channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.chunk), (Object)new StickyChunkUpdateSerializer.StickyChunkUpdateMessage(this.chunk.m_7697_(), this));
        }
    }

    public void clearData(int x, int y, int z) {
        int idx = (y & 0xFF) << 8 | (z & 0xF) << 4 | x & 0xF;
        this.stickies[idx] = 0;
        this.indicesWithGlue = null;
        if (this.chunk != null && !this.chunk.m_62953_().f_46443_) {
            this.chunk.m_8092_(true);
            UtilitiX.getNetwork().channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.chunk), (Object)new StickyChunkUpdateSerializer.StickyChunkUpdateMessage(this.chunk.m_7697_(), this));
        }
    }

    public void foreach(StickyAction action) {
        if (this.indicesWithGlue == null) {
            this.indicesWithGlue = new HashSet<Integer>();
            for (int idx = 0; idx < this.stickies.length; ++idx) {
                byte data = this.stickies[idx];
                if (data == 0) continue;
                this.indicesWithGlue.add(idx);
            }
        }
        for (int idx : this.indicesWithGlue) {
            byte data = this.stickies[idx];
            if (data == 0) continue;
            int y = idx >>> 8 & 0xFF;
            int z = idx >>> 4 & 0xF;
            int x = idx & 0xF;
            action.accept(x, y, z, data);
        }
    }

    public byte[] getStickies() {
        return this.stickies;
    }

    public void setStickies(byte[] data) {
        if (data.length != 65536) {
            throw new IllegalStateException("Invalid size of sticky data for chunk: " + data.length);
        }
        this.stickies = data;
        this.indicesWithGlue = null;
    }

    public void attach(LevelChunk chunk) {
        this.chunk = chunk;
    }

    public static interface StickyAction {
        public void accept(int var1, int var2, int var3, byte var4);
    }
}

