/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.carts;

import com.google.common.collect.ImmutableSet;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.track.carts.ItemCart;
import de.melanx.utilitix.content.track.carts.MinecartRendererX;
import io.github.noeppi_noeppi.libx.base.ItemBase;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class Cart
extends AbstractMinecart {
    private static final Map<EntityType<?>, Item> cartItems = Collections.synchronizedMap(new HashMap());

    protected Cart(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Nonnull
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    public ItemStack getCartItem() {
        return new ItemStack((ItemLike)cartItems.getOrDefault(this.m_6095_(), Items.f_42449_));
    }

    public boolean canBeRidden() {
        return false;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static <T extends Cart> CartType<T> type(String id, EntityType.EntityFactory<T> factory) {
        return Cart.type(id, factory, new Item.Properties().m_41487_(1));
    }

    public static <T extends Cart> CartType<T> type(String id, EntityType.EntityFactory<T> factory, Item.Properties properties) {
        final EntityType type = EntityType.Builder.m_20704_(factory, (MobCategory)MobCategory.MISC).m_20699_(0.98f, 0.7f).m_20702_(8).m_20712_(UtilitiX.getInstance().modid + "_" + id);
        final ItemCart item = new ItemCart((ModX)UtilitiX.getInstance(), (EntityType<? extends Cart>)type, properties);
        cartItems.put(type, (Item)item);
        return new CartType<T>(){

            @Override
            public EntityType<T> get() {
                return type;
            }

            @Override
            public ItemBase item() {
                return item;
            }

            public Set<Object> getAdditionalRegisters(ResourceLocation id) {
                return ImmutableSet.of((Object)type, (Object)item);
            }

            @OnlyIn(value=Dist.CLIENT)
            public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
                EntityRenderers.m_174036_((EntityType)type, context -> new MinecartRendererX(context, ModelLayers.f_171198_));
            }
        };
    }

    public static double getHorizontalDistanceSqr(Vec3 vec) {
        return vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_;
    }

    public static interface CartType<T extends Cart>
    extends Registerable {
        public EntityType<T> get();

        public ItemBase item();
    }
}

