/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.carts;

import de.melanx.utilitix.UtilitiXConfig;
import de.melanx.utilitix.content.track.carts.Cart;
import de.melanx.utilitix.content.track.carts.stonecutter.StonecutterCartMode;
import de.melanx.utilitix.registration.ModSerializers;
import io.github.noeppi_noeppi.libx.util.NBTX;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class StonecutterCart
extends Cart {
    public static final int MAX_PROGRESS = 50;
    private static final EntityDataAccessor<StonecutterCartMode> MODE = SynchedEntityData.m_135353_(StonecutterCart.class, ModSerializers.stonecutterCartMode);
    private static final EntityDataAccessor<Boolean> IN_REVERSE = SynchedEntityData.m_135353_(StonecutterCart.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private StonecutterCartMode mode = StonecutterCartMode.TOP;
    @Nullable
    private BlockPos breakingBlock = null;
    @Nullable
    private BlockPos lastSuccess = null;
    private int breakProgress = 0;
    @Nullable
    private Vec3 storedMotion = null;
    private boolean cartHasMoved = false;

    public StonecutterCart(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MODE, (Object)StonecutterCartMode.TOP);
        this.f_19804_.m_135372_(IN_REVERSE, (Object)false);
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (MODE.equals(key)) {
            this.mode = (StonecutterCartMode)((Object)this.f_19804_.m_135370_(MODE));
        } else if (IN_REVERSE.equals(key)) {
            this.f_38068_ = (Boolean)this.f_19804_.m_135370_(IN_REVERSE);
        }
    }

    @Nonnull
    public BlockState m_6390_() {
        return Blocks.f_50679_.m_49966_();
    }

    public void m_7617_(@Nonnull DamageSource source) {
        super.m_7617_(source);
        this.m_19998_((ItemLike)Items.f_42776_);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.breakingBlock != null) {
            this.f_19853_.m_6801_(this.m_142049_(), this.breakingBlock, -1);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            int oz;
            BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()));
            if (!this.f_19853_.m_8055_(pos).m_60620_((Tag)BlockTags.f_13034_) && this.f_19853_.m_8055_(pos.m_7495_()).m_60620_((Tag)BlockTags.f_13034_)) {
                pos = pos.m_7495_();
            }
            Direction minecartDir = this.m_6374_();
            Direction leftDir = minecartDir.m_122428_();
            int ox = minecartDir.m_122429_() * this.getMode().offsetTrack + leftDir.m_122429_() * this.getMode().offsetLeft;
            if (!(pos = pos.m_142082_(ox, this.getMode().offsetHor, oz = minecartDir.m_122431_() * this.getMode().offsetTrack + leftDir.m_122431_() * this.getMode().offsetLeft)).equals((Object)this.breakingBlock)) {
                if (this.breakingBlock != null) {
                    this.f_19853_.m_6801_(this.m_142049_(), this.breakingBlock, -1);
                }
                this.breakingBlock = pos;
                this.breakProgress = 0;
            }
            boolean shouldResetMotion = true;
            if (!this.breakingBlock.equals((Object)this.lastSuccess) && this.cartHasMoved) {
                BlockState state = this.f_19853_.m_8055_(this.breakingBlock);
                if (!(state.m_60795_() || state.m_60767_().m_76336_() || BlockTags.f_13034_.m_8110_((Object)state.m_60734_()))) {
                    float hardness = state.m_60800_((BlockGetter)this.f_19853_, this.breakingBlock);
                    if (hardness >= 0.0f && hardness <= UtilitiXConfig.Track.stonecutterMaxHardness) {
                        this.breakProgress = (int)((float)this.breakProgress + Mth.m_14036_((float)(5.0f - hardness), (float)1.0f, (float)5.0f));
                        if (this.breakProgress >= 50 || hardness == 0.0f) {
                            List drops = null;
                            if (this.f_19853_ instanceof ServerLevel) {
                                drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)this.f_19853_), (BlockPos)this.breakingBlock, (BlockEntity)this.f_19853_.m_7702_(pos));
                            }
                            this.f_19853_.m_7731_(this.breakingBlock, Blocks.f_50016_.m_49966_(), 11);
                            if (drops != null) {
                                for (ItemStack drop : drops) {
                                    ItemEntity ie = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop.m_41777_());
                                    ie.m_20256_(Vec3.f_82478_);
                                    this.f_19853_.m_7967_((Entity)ie);
                                }
                            }
                            this.f_19853_.m_6801_(this.m_142049_(), this.breakingBlock, -1);
                            this.lastSuccess = this.breakingBlock;
                            this.breakingBlock = null;
                            this.breakProgress = 0;
                        } else {
                            int stage = Mth.m_14045_((int)Math.round((float)this.breakProgress / 50.0f * 10.0f), (int)0, (int)9);
                            this.f_19853_.m_6801_(this.m_142049_(), this.breakingBlock, stage);
                            if (this.storedMotion == null) {
                                this.storedMotion = this.m_20184_();
                            }
                            this.m_20256_(Vec3.f_82478_);
                            shouldResetMotion = false;
                        }
                    } else {
                        this.breakProgress = 0;
                    }
                } else {
                    this.breakProgress = 0;
                }
            }
            if (shouldResetMotion && this.storedMotion != null) {
                this.m_20256_(this.storedMotion);
                this.storedMotion = null;
            }
            if (StonecutterCart.getHorizontalDistanceSqr(this.m_20184_()) >= 0.010000000000000002) {
                this.cartHasMoved = true;
            }
        }
        if (!this.f_19853_.f_46443_ && this.f_38068_ != (Boolean)this.f_19804_.m_135370_(IN_REVERSE)) {
            this.f_19804_.m_135381_(IN_REVERSE, (Object)this.f_38068_);
        }
    }

    public StonecutterCartMode getMode() {
        return this.mode;
    }

    public void setMode(StonecutterCartMode mode) {
        this.mode = mode;
        this.f_19804_.m_135381_(MODE, (Object)mode);
    }

    @Nonnull
    public InteractionResult m_6096_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        InteractionResult ret = super.m_6096_(player, hand);
        if (ret.m_19077_()) {
            return ret;
        }
        if (!this.f_19853_.f_46443_) {
            int modeIdx = this.getMode().ordinal();
            StonecutterCartMode[] modes = StonecutterCartMode.values();
            this.setMode(modes[(modeIdx + 1) % modes.length]);
        }
        return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
    }

    protected void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        String modeName = compound.m_128461_("Mode");
        try {
            this.mode = StonecutterCartMode.valueOf(modeName);
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            this.mode = StonecutterCartMode.TOP;
        }
        if (this.mode != this.f_19804_.m_135370_(MODE)) {
            this.f_19804_.m_135381_(MODE, (Object)this.mode);
        }
        this.breakingBlock = NBTX.getPos((CompoundTag)compound, (String)"BreakPos");
        this.lastSuccess = NBTX.getPos((CompoundTag)compound, (String)"LastSuccessfulBreak");
        this.breakProgress = compound.m_128451_("BreakProgress");
        if (compound.m_128425_("StoredMotion", 10)) {
            CompoundTag motionNbt = compound.m_128469_("StoredMotion");
            this.storedMotion = new Vec3(motionNbt.m_128459_("X"), motionNbt.m_128459_("Y"), motionNbt.m_128459_("Z"));
        } else {
            this.storedMotion = null;
        }
        this.cartHasMoved = compound.m_128471_("CartHasMoved");
    }

    protected void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Mode", this.mode.name());
        if (this.breakingBlock == null) {
            compound.m_128473_("BreakPos");
        } else {
            NBTX.putPos((CompoundTag)compound, (String)"BreakPos", (BlockPos)this.breakingBlock);
        }
        if (this.lastSuccess == null) {
            compound.m_128473_("LastSuccessfulBreak");
        } else {
            NBTX.putPos((CompoundTag)compound, (String)"LastSuccessfulBreak", (BlockPos)this.lastSuccess);
        }
        compound.m_128405_("BreakProgress", this.breakProgress);
        if (this.storedMotion == null) {
            compound.m_128473_("StoredMotion");
        } else {
            CompoundTag motionNBT = new CompoundTag();
            motionNBT.m_128347_("X", this.storedMotion.f_82479_);
            motionNBT.m_128347_("Y", this.storedMotion.f_82480_);
            motionNBT.m_128347_("Z", this.storedMotion.f_82481_);
            compound.m_128365_("StoredMotion", (net.minecraft.nbt.Tag)motionNBT);
        }
        compound.m_128379_("CartHasMoved", this.cartHasMoved);
    }
}

