/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import de.melanx.utilitix.content.track.rails.BlockRail;
import io.github.noeppi_noeppi.libx.mod.ModX;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public abstract class BlockPowerableRail
extends BlockRail {
    @Nullable
    private final Tag<Block> powerables;

    public BlockPowerableRail(ModX mod, @Nullable Tag<Block> powerables, BlockBehaviour.Properties properties) {
        this(mod, powerables, properties, new Item.Properties());
    }

    public BlockPowerableRail(ModX mod, @Nullable Tag<Block> powerables, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, false, properties, itemProperties);
        this.powerables = powerables;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61448_});
    }

    protected boolean findPower(Level level, BlockPos pos, BlockState state, boolean searchForward, int recursionCount) {
        if (recursionCount >= 8 || !(state.m_60734_() instanceof BlockPowerableRail)) {
            return false;
        }
        BlockPos searchPos = pos.m_7949_();
        boolean lookDown = true;
        RailShape rail = (RailShape)state.m_61143_(((BlockPowerableRail)state.m_60734_()).m_7978_());
        switch (rail) {
            case NORTH_SOUTH: {
                searchPos = searchPos.m_142300_(searchForward ? Direction.SOUTH : Direction.NORTH);
                break;
            }
            case EAST_WEST: {
                searchPos = searchPos.m_142300_(searchForward ? Direction.EAST : Direction.WEST);
                break;
            }
            case ASCENDING_EAST: {
                if (searchForward) {
                    searchPos = searchPos.m_142125_();
                } else {
                    searchPos = searchPos.m_142126_().m_7494_();
                    lookDown = false;
                }
                rail = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (searchForward) {
                    searchPos = searchPos.m_142125_().m_7494_();
                    lookDown = false;
                } else {
                    searchPos = searchPos.m_142126_();
                }
                rail = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (searchForward) {
                    searchPos = searchPos.m_142128_();
                } else {
                    searchPos = searchPos.m_142127_().m_7494_();
                    lookDown = false;
                }
                rail = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (searchForward) {
                    searchPos = searchPos.m_142128_().m_7494_();
                    lookDown = false;
                } else {
                    searchPos = searchPos.m_142127_();
                }
                rail = RailShape.NORTH_SOUTH;
            }
        }
        return this.canPower(level, searchPos, searchForward, recursionCount, rail) || lookDown && this.canMakeSlopes(level.m_8055_(searchPos), (BlockGetter)level, searchPos) && this.canPower(level, searchPos.m_7495_(), searchForward, recursionCount, rail);
    }

    private boolean canPower(Level level, BlockPos pos, boolean searchForward, int recursionCount, RailShape shape) {
        RailShape rail;
        BlockState target = level.m_8055_(pos);
        if (!(target.m_60734_() instanceof BlockPowerableRail)) {
            return false;
        }
        RailShape railShape = rail = target.m_60734_() == this ? this.getRailDirection(target, (BlockGetter)level, pos, null) : RailShape.NORTH_SOUTH;
        if (shape == RailShape.EAST_WEST && (rail == RailShape.NORTH_SOUTH || rail == RailShape.ASCENDING_NORTH || rail == RailShape.ASCENDING_SOUTH)) {
            return false;
        }
        if (shape == RailShape.NORTH_SOUTH && (rail == RailShape.EAST_WEST || rail == RailShape.ASCENDING_EAST || rail == RailShape.ASCENDING_WEST)) {
            return false;
        }
        if (this.powerables == null ? target.m_60734_() == this : this.powerables.m_8110_((Object)target.m_60734_())) {
            return level.m_46753_(pos) || this.findPower(level, pos, target, searchForward, recursionCount + 1);
        }
        return false;
    }

    protected void m_6360_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block) {
        if (state.m_60734_() == this) {
            boolean shouldBePowered;
            boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
            boolean bl = shouldBePowered = level.m_46753_(pos) || this.findPower(level, pos, state, true, 0) || this.findPower(level, pos, state, false, 0);
            if (powered != shouldBePowered) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
                level.m_46672_(pos.m_7495_(), (Block)this);
                if (((RailShape)state.m_61143_(this.m_7978_())).m_61745_()) {
                    level.m_46672_(pos.m_7494_(), (Block)this);
                }
            }
        }
    }
}

