/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.mixin;

import de.melanx.utilitix.block.ComparatorRedirector;
import de.melanx.utilitix.registration.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class})
public abstract class MixinLevel {
    @Inject(method={"updateNeighbourForOutputSignal"}, at={@At(value="RETURN")})
    public void updateComparatorOutputLevel(BlockPos pos, Block block, CallbackInfo ci) {
        if (!(block instanceof ComparatorRedirector)) {
            BlockState down;
            BlockState up = ((Level)this).m_8055_(pos.m_7494_());
            if (up.m_60734_() instanceof ComparatorRedirector) {
                ((Level)this).m_46717_(pos.m_7494_(), up.m_60734_());
            }
            if ((down = ((Level)this).m_8055_(pos.m_7495_())).m_60734_() instanceof ComparatorRedirector) {
                ((Level)this).m_46717_(pos.m_7495_(), down.m_60734_());
            }
        }
    }

    @Redirect(method={"getBestNeighborSignal"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getSignal(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)I"))
    public int getRedstonePowerAsCallFromNeighbours(Level level, BlockPos pos, Direction facing) {
        int power = 0;
        BlockState state = level.m_8055_(pos);
        if (state.m_60746_((BlockGetter)level, pos, facing) > 0) {
            power = level.m_46681_(pos, facing);
        }
        if (state.shouldCheckWeakPower((LevelReader)level, pos, facing)) {
            power = Math.max(power, this.getNearStrongPower(level, pos));
        }
        return power;
    }

    @Unique
    private int getNearStrongPower(Level level, BlockPos pos) {
        BlockPos posDown = pos.m_7495_();
        Block block = level.m_8055_(posDown).m_60734_();
        if (block == ModBlocks.weakRedstoneTorch || block == ModBlocks.weakRedstoneTorch.wallTorch) {
            int power = level.m_46852_(pos.m_7494_(), Direction.UP);
            if (power >= 15) {
                return power;
            }
            if ((power = Math.max(power, level.m_46852_(pos.m_142127_(), Direction.NORTH))) >= 15) {
                return power;
            }
            if ((power = Math.max(power, level.m_46852_(pos.m_142128_(), Direction.SOUTH))) >= 15) {
                return power;
            }
            if ((power = Math.max(power, level.m_46852_(pos.m_142125_(), Direction.WEST))) >= 15) {
                return power;
            }
            power = Math.max(power, level.m_46852_(pos.m_142126_(), Direction.EAST));
            return power;
        }
        return level.m_46751_(pos);
    }
}

