/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.mixin;

import de.melanx.utilitix.content.slime.SlimyCapability;
import de.melanx.utilitix.content.slime.StickyChunk;
import de.melanx.utilitix.util.MixinUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PistonMovingBlockEntity.class})
public class MixinPistonMovingBlockEntity {
    @Unique
    private Byte glueData;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private static void tick(Level level, BlockPos pos, BlockState state, PistonMovingBlockEntity blockEntity, CallbackInfo ci) {
        BlockPos fromPos;
        LevelChunk chunk;
        StickyChunk glue;
        if (((MixinPistonMovingBlockEntity)blockEntity).glueData == null && (glue = (StickyChunk)(chunk = level.m_46745_(fromPos = pos.m_142300_(blockEntity.m_60387_() ? blockEntity.m_60392_().m_122424_() : blockEntity.m_60392_()))).getCapability(SlimyCapability.STICKY_CHUNK).orElse(null)) != null) {
            int x = fromPos.m_123341_() & 0xF;
            int y = fromPos.m_123342_();
            int z = fromPos.m_123343_() & 0xF;
            ((MixinPistonMovingBlockEntity)blockEntity).glueData = glue.getData(x, y, z);
            glue.clearData(x, y, z);
            chunk.m_8092_(true);
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", shift=At.Shift.AFTER)})
    private static void afterSetBlockState(Level level, BlockPos pos, BlockState state, PistonMovingBlockEntity blockEntity, CallbackInfo ci) {
        MixinUtil.afterSetBlockState(level, pos, ((MixinPistonMovingBlockEntity)blockEntity).glueData);
    }

    @Inject(method={"finalTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", shift=At.Shift.AFTER)})
    public void afterSetBlockState(CallbackInfo ci) {
        PistonMovingBlockEntity blockEntity = (PistonMovingBlockEntity)this;
        Level level = blockEntity.m_58904_();
        BlockPos pos = blockEntity.m_58899_();
        MixinUtil.afterSetBlockState(level, pos, this.glueData);
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    public void read(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128425_("utilitix_glue_data", 99)) {
            this.glueData = nbt.m_128445_("utilitix_glue_data");
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")})
    public void write(CompoundTag nbt, CallbackInfo ci) {
        if (this.glueData != null) {
            nbt.m_128344_("utilitix_glue_data", this.glueData.byteValue());
        }
    }
}

