/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.utilitix.recipe.PotionInput;
import de.melanx.utilitix.recipe.PotionOutput;
import de.melanx.utilitix.registration.ModItemTags;
import de.melanx.utilitix.registration.ModItems;
import io.github.noeppi_noeppi.libx.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EffectTransformer {
    private EffectTransformer() {
    }

    public abstract boolean canTransform(PotionInput var1);

    public abstract ItemStack output();

    @Nullable
    public abstract PotionOutput transform(PotionInput var1);

    public abstract JsonObject serialize();

    public abstract void write(FriendlyByteBuf var1);

    public static EffectTransformer deserialize(JsonObject json) {
        String type = json.get("type").getAsString();
        if ("apply".equalsIgnoreCase(type)) {
            MutableComponent name = json.has("name") ? Component.Serializer.m_130691_((JsonElement)json.get("name")) : null;
            ImmutableList.Builder effects = ImmutableList.builder();
            JsonArray list = json.get("effects").getAsJsonArray();
            for (int i = 0; i < list.size(); ++i) {
                effects.add((Object)EffectTransformer.deserializeEffect(list.get(i).getAsJsonObject()));
            }
            return new Apply((Component)name, (List<MobEffectInstance>)effects.build());
        }
        if ("merge".equalsIgnoreCase(type)) {
            return new Merge(json.get("fail_multiplier").getAsFloat());
        }
        if ("upgrade".equalsIgnoreCase(type)) {
            return new Upgrade(Math.max(0, json.get("max_level").getAsInt() - 1));
        }
        if ("clone".equalsIgnoreCase(type)) {
            return new Clone();
        }
        throw new IllegalStateException("Invalid json: Unknown effect transformer type: " + type);
    }

    public static EffectTransformer read(FriendlyByteBuf buffer) {
        byte id = buffer.readByte();
        if (id == 0) {
            Component name = null;
            if (buffer.readBoolean()) {
                name = buffer.m_130238_();
            }
            ImmutableList.Builder effects = ImmutableList.builder();
            int size = buffer.m_130242_();
            for (int i = 0; i < size; ++i) {
                CompoundTag nbt = buffer.m_130260_();
                if (nbt == null) continue;
                effects.add((Object)MobEffectInstance.m_19560_((CompoundTag)nbt));
            }
            return new Apply(name, (List<MobEffectInstance>)effects.build());
        }
        if (id == 1) {
            return new Merge(buffer.readFloat());
        }
        if (id == 2) {
            return new Upgrade(buffer.m_130242_());
        }
        if (id == 3) {
            return new Clone();
        }
        throw new IllegalStateException("Invalid packet: Unknown effect transformer type: " + id);
    }

    public static ItemStack create(Item item, List<MobEffectInstance> effects) {
        ItemStack stack = new ItemStack((ItemLike)item);
        PotionUtils.m_43552_((ItemStack)stack, effects);
        stack.m_41784_().m_128405_("CustomPotionColor", PotionUtils.m_43564_(effects));
        return stack;
    }

    public static JsonObject serializeEffect(MobEffectInstance effect) {
        JsonObject json = new JsonObject();
        ResourceLocation id = effect.m_19544_().getRegistryName();
        if (id == null) {
            id = Misc.MISSIGNO;
        }
        json.addProperty("effect", id.toString());
        json.addProperty("amplifier", (Number)(effect.m_19564_() + 1));
        json.addProperty("duration", (Number)effect.m_19557_());
        if (effect.m_19571_()) {
            json.addProperty("ambient", Boolean.valueOf(effect.m_19571_()));
        }
        if (!effect.m_19572_()) {
            json.addProperty("particles", Boolean.valueOf(effect.m_19572_()));
        }
        return json;
    }

    public static MobEffectInstance deserializeEffect(JsonObject json) {
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)json.get("effect").getAsString()));
        int amplifier = Math.max(0, json.get("amplifier").getAsInt() - 1);
        int duration = Math.max(1, json.get("duration").getAsInt());
        boolean ambient = json.has("ambient") && json.get("ambient").getAsBoolean();
        boolean particles = !json.has("particles") || json.get("particles").getAsBoolean();
        return new MobEffectInstance(effect == null ? MobEffects.f_19596_ : effect, duration, amplifier, ambient, particles);
    }

    public static class Apply
    extends EffectTransformer {
        @Nullable
        private final Component name;
        private final List<MobEffectInstance> effects;

        public Apply(MobEffectInstance ... effects) {
            this((Component)null, effects);
        }

        public Apply(List<MobEffectInstance> effects) {
            this(null, effects);
        }

        public Apply(@Nullable Component name, MobEffectInstance ... effects) {
            this(name, (List<MobEffectInstance>)ImmutableList.copyOf((Object[])effects));
        }

        public Apply(@Nullable Component name, List<MobEffectInstance> effects) {
            this.name = name;
            this.effects = ImmutableList.copyOf(effects);
        }

        @Override
        public boolean canTransform(PotionInput input) {
            return ModItemTags.POTIONS.m_8110_((Object)input.getMain().m_41720_()) && input.testEffectsMain(List::isEmpty) && input.getIn1().m_41619_() && input.getIn2().m_41619_();
        }

        @Override
        public ItemStack output() {
            ItemStack stack = Apply.create(Items.f_42589_, this.effects);
            if (this.name != null) {
                stack.m_41714_((Component)this.name.m_6881_());
            }
            return stack;
        }

        @Override
        @Nullable
        public PotionOutput transform(PotionInput input) {
            ItemStack stack = Apply.create(input.getMain().m_41720_(), this.effects);
            if (this.name != null) {
                stack.m_41714_((Component)this.name.m_6881_());
            }
            return PotionOutput.simple(stack);
        }

        @Override
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "apply");
            if (this.name != null) {
                json.add("name", Component.Serializer.m_130716_((Component)this.name));
            }
            JsonArray list = new JsonArray();
            for (MobEffectInstance effect : this.effects) {
                list.add((JsonElement)Apply.serializeEffect(effect));
            }
            json.add("effects", (JsonElement)list);
            return json;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeByte(0);
            buffer.writeBoolean(this.name != null);
            if (this.name != null) {
                buffer.m_130083_(this.name);
            }
            buffer.m_130130_(this.effects.size());
            for (MobEffectInstance effect : this.effects) {
                buffer.m_130079_(effect.m_19555_(new CompoundTag()));
            }
        }
    }

    public static class Merge
    extends EffectTransformer {
        private final float failMultiplier;

        public Merge(float failMultiplier) {
            this.failMultiplier = failMultiplier;
        }

        @Override
        public boolean canTransform(PotionInput input) {
            return input.getMain().m_41720_() == Items.f_42590_ && input.getIn1().m_41720_() == input.getIn2().m_41720_() && input.testEffects1(list -> !list.isEmpty()) && input.testEffects2(list -> !list.isEmpty());
        }

        @Override
        public ItemStack output() {
            return new ItemStack((ItemLike)Items.f_42589_);
        }

        @Override
        @Nullable
        public PotionOutput transform(PotionInput input) {
            ArrayList<MobEffectInstance> merged = new ArrayList<MobEffectInstance>();
            if (input.getEffects1() != null) {
                for (MobEffectInstance effect : input.getEffects1()) {
                    this.addMergedEffectToList(effect.m_19544_(), merged, input.getEffects1(), input.getEffects2());
                }
            }
            if (input.getEffects2() != null) {
                for (MobEffectInstance effect : input.getEffects2()) {
                    this.addMergedEffectToList(effect.m_19544_(), merged, input.getEffects1(), input.getEffects2());
                }
            }
            float chance = (float)Math.max(0, merged.size() + 1) * this.failMultiplier;
            Random random = new Random();
            if ((float)random.nextInt(100) < chance) {
                return PotionOutput.simple(new ItemStack((ItemLike)ModItems.failedPotion));
            }
            ItemStack stack = Merge.create(input.getIn1().m_41720_(), merged);
            stack.m_41714_((Component)new TranslatableComponent("item.utilitix.merged_potion").m_130940_(ChatFormatting.GREEN));
            return PotionOutput.simple(stack);
        }

        private void addMergedEffectToList(MobEffect potion, List<MobEffectInstance> mergeList, @Nullable List<MobEffectInstance> list1, @Nullable List<MobEffectInstance> list2) {
            for (MobEffectInstance effect : mergeList) {
                if (effect.m_19544_() != potion) continue;
                return;
            }
            MobEffectInstance effect1 = null;
            MobEffectInstance effect2 = null;
            if (list1 != null) {
                for (MobEffectInstance effect : list1) {
                    if (effect.m_19544_() != potion) continue;
                    effect1 = effect;
                    break;
                }
            }
            if (list2 != null) {
                for (MobEffectInstance effect : list2) {
                    if (effect.m_19544_() != potion) continue;
                    effect2 = effect;
                    break;
                }
            }
            if (effect1 != null || effect2 != null) {
                if (effect1 == null) {
                    mergeList.add(effect2);
                } else if (effect2 == null) {
                    mergeList.add(effect1);
                } else {
                    boolean useFirst;
                    if (effect1.m_19564_() > effect2.m_19564_()) {
                        useFirst = true;
                    } else if (effect2.m_19564_() > effect1.m_19564_()) {
                        useFirst = false;
                    } else {
                        boolean bl = useFirst = effect1.m_19557_() > effect2.m_19557_();
                    }
                    if (useFirst) {
                        mergeList.add(effect1);
                    } else {
                        mergeList.add(effect2);
                    }
                }
            }
        }

        @Override
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "merge");
            json.addProperty("fail_multiplier", (Number)Float.valueOf(this.failMultiplier));
            return json;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeByte(1);
            buffer.writeFloat(this.failMultiplier);
        }
    }

    public static class Upgrade
    extends EffectTransformer {
        private final int maxLevel;

        public Upgrade(int maxLevel) {
            this.maxLevel = maxLevel;
        }

        @Override
        public boolean canTransform(PotionInput input) {
            return input.testEffectsMain(list -> list.size() == 1 && ((MobEffectInstance)list.get(0)).m_19564_() < this.maxLevel) && input.getIn1().m_41619_() && input.getIn2().m_41619_();
        }

        @Override
        public ItemStack output() {
            return new ItemStack((ItemLike)Items.f_42589_);
        }

        @Override
        @Nullable
        public PotionOutput transform(PotionInput input) {
            if (input.getEffectsMain() == null || input.getEffectsMain().isEmpty()) {
                return null;
            }
            MobEffectInstance old = input.getEffectsMain().get(0);
            ItemStack newStack = Upgrade.create(input.getMain().m_41720_(), (List<MobEffectInstance>)ImmutableList.of((Object)new MobEffectInstance(old.m_19544_(), old.m_19557_(), Mth.m_14045_((int)(old.m_19564_() + 1), (int)0, (int)this.maxLevel), old.m_19571_(), old.m_19572_())));
            newStack.m_41714_(input.getMain().m_41786_());
            return PotionOutput.simple(newStack);
        }

        @Override
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "upgrade");
            json.addProperty("max_level", (Number)(this.maxLevel + 1));
            return json;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeByte(2);
            buffer.m_130130_(this.maxLevel);
        }
    }

    public static class Clone
    extends EffectTransformer {
        @Override
        public boolean canTransform(PotionInput input) {
            return input.testEffectsMain(list -> !list.isEmpty()) && ModItemTags.POTIONS.m_8110_((Object)input.getIn1().m_41720_()) && input.getEffects1() == null && ModItemTags.POTIONS.m_8110_((Object)input.getIn2().m_41720_()) && input.getEffects2() == null;
        }

        @Override
        public ItemStack output() {
            return new ItemStack((ItemLike)Items.f_42589_);
        }

        @Override
        @Nullable
        public PotionOutput transform(PotionInput input) {
            return PotionOutput.create(ItemStack.f_41583_, input.getMain().m_41777_(), input.getMain().m_41777_());
        }

        @Override
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "clone");
            return json;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeByte(3);
        }
    }
}

