/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.ServerProxy;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.CitadelItemRenderProperties;
import com.github.alexthe666.citadel.client.CitadelPatreonRenderer;
import com.github.alexthe666.citadel.client.event.EventGetOutlineColor;
import com.github.alexthe666.citadel.client.event.EventPosePlayerHand;
import com.github.alexthe666.citadel.client.gui.GuiCitadelBook;
import com.github.alexthe666.citadel.client.gui.GuiCitadelPatreonConfig;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.TabulaModelHandler;
import com.github.alexthe666.citadel.client.patreon.SpaceStationPatreonRenderer;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.SkinCustomizationScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientProxy
extends ServerProxy {
    public static TabulaModel CITADEL_MODEL;
    private static final ResourceLocation CITADEL_TEXTURE;
    private static final ResourceLocation CITADEL_TEXTURE_RED;
    private static final ResourceLocation CITADEL_TEXTURE_GRAY;

    @Override
    public void onPreInit() {
        try {
            CITADEL_MODEL = new TabulaModel(TabulaModelHandler.INSTANCE.loadTabulaModel("/assets/citadel/models/citadel_model"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CitadelPatreonRenderer.register("citadel", new SpaceStationPatreonRenderer(CITADEL_TEXTURE));
        CitadelPatreonRenderer.register("citadel_red", new SpaceStationPatreonRenderer(CITADEL_TEXTURE_RED));
        CitadelPatreonRenderer.register("citadel_gray", new SpaceStationPatreonRenderer(CITADEL_TEXTURE_GRAY));
    }

    @SubscribeEvent
    public void openCustomizeSkinScreen(ScreenEvent.InitScreenEvent event) {
        if (event.getScreen() instanceof SkinCustomizationScreen && Minecraft.m_91087_().f_91074_ != null) {
            try {
                String username = Minecraft.m_91087_().f_91074_.m_7755_().m_6111_();
                if (Citadel.PATREONS.contains(username)) {
                    event.addListener((GuiEventListener)new Button(event.getScreen().f_96543_ / 2 - 100, event.getScreen().f_96544_ / 6 + 150, 200, 20, (Component)new TranslatableComponent("citadel.gui.patreon_rewards_option").m_130940_(ChatFormatting.GREEN), p_213080_2_ -> Minecraft.m_91087_().m_91152_((Screen)new GuiCitadelPatreonConfig(event.getScreen(), Minecraft.m_91087_().f_91066_))));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void playerRender(RenderPlayerEvent.Post event) {
        PoseStack matrixStackIn = event.getPoseStack();
        String username = event.getPlayer().m_7755_().m_6111_();
        if (!event.getPlayer().m_36170_(PlayerModelPart.CAPE)) {
            return;
        }
        if (Citadel.PATREONS.contains(username)) {
            CitadelPatreonRenderer renderer;
            String rendererName;
            CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.m_91087_().f_91074_);
            String string = rendererName = tag.m_128441_("CitadelFollowerType") ? tag.m_128461_("CitadelFollowerType") : "citadel";
            if (!rendererName.equals("none") && (renderer = CitadelPatreonRenderer.get(rendererName)) != null) {
                float distance = tag.m_128441_("CitadelRotateDistance") ? tag.m_128457_("CitadelRotateDistance") : 2.0f;
                float speed = tag.m_128441_("CitadelRotateSpeed") ? tag.m_128457_("CitadelRotateSpeed") : 1.0f;
                float height = tag.m_128441_("CitadelRotateHeight") ? tag.m_128457_("CitadelRotateHeight") : 1.0f;
                renderer.render(matrixStackIn, event.getMultiBufferSource(), event.getPackedLight(), event.getPartialTick(), event.getEntityLiving(), distance, speed, height);
            }
        }
    }

    @Override
    public void handleAnimationPacket(int entityId, int index) {
        IAnimatedEntity entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (entity = (IAnimatedEntity)player.f_19853_.m_6815_(entityId)) != null) {
            if (index == -1) {
                entity.setAnimation(IAnimatedEntity.NO_ANIMATION);
            } else {
                entity.setAnimation(entity.getAnimations()[index]);
            }
            entity.setAnimationTick(0);
        }
    }

    @Override
    public void handlePropertiesPacket(String propertyID, CompoundTag compound, int entityID) {
        if (compound == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Entity entity = player.f_19853_.m_6815_(entityID);
        if ((propertyID.equals("CitadelPatreonConfig") || propertyID.equals("CitadelTagUpdate")) && entity instanceof LivingEntity) {
            CitadelEntityData.setCitadelTag((LivingEntity)entity, compound);
        }
    }

    @Override
    public Object getISTERProperties() {
        return new CitadelItemRenderProperties();
    }

    @Override
    public void openBookGUI(ItemStack book) {
        Minecraft.m_91087_().m_91152_((Screen)new GuiCitadelBook(book));
    }

    @SubscribeEvent
    public void outlineColorTest(EventGetOutlineColor event) {
    }

    @SubscribeEvent
    public void animateHandTest(EventPosePlayerHand event) {
    }

    static {
        CITADEL_TEXTURE = new ResourceLocation("citadel", "textures/patreon/citadel_model.png");
        CITADEL_TEXTURE_RED = new ResourceLocation("citadel", "textures/patreon/citadel_model_red.png");
        CITADEL_TEXTURE_GRAY = new ResourceLocation("citadel", "textures/patreon/citadel_model_gray.png");
    }
}

