/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block;

import com.technicalitiesmc.lib.block.BlockComponentData;
import com.technicalitiesmc.lib.block.TKBlock;
import com.technicalitiesmc.lib.block.TKBlockEntity;
import com.technicalitiesmc.lib.block.multipart.Multipart;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockComponent {
    final Context context;

    private BlockComponent(Context context) {
        this.context = context;
    }

    protected final TKBlock getBlock() {
        return this.context.getBlock();
    }

    protected InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return 0;
    }

    public static interface Context {
        public TKBlock getBlock();
    }

    @FunctionalInterface
    public static interface Constructor<T> {
        public T create(Context var1);
    }

    public static abstract class WithData<T extends BlockComponentData>
    extends BlockComponent {
        private final BlockComponentData.Constructor<T> constructor;

        public WithData(Context context, BlockComponentData.Constructor<T> constructor) {
            super(context);
            this.constructor = constructor;
        }

        final T createData(BlockComponentData.Context context) {
            return this.constructor.create(context);
        }

        @Nullable
        protected final T getData(BlockGetter level, BlockPos pos, BlockState state) {
            T t;
            BlockEntity entity = Multipart.getBlockEntity(level, pos, state);
            if (entity instanceof TKBlockEntity) {
                TKBlockEntity tkEntity = (TKBlockEntity)entity;
                t = tkEntity.get(this);
            } else {
                t = null;
            }
            return t;
        }
    }

    public static abstract class WithoutData
    extends BlockComponent {
        public WithoutData(Context context) {
            super(context);
        }
    }
}

