/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block;

import com.technicalitiesmc.lib.block.BlockComponent;
import com.technicalitiesmc.lib.block.TKBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.RegistryObject;

public abstract class TKBlock
extends Block
implements BlockComponent.Context {
    private final List<BlockComponent> components = new ArrayList<BlockComponent>();

    public TKBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    final <T extends BlockComponent> T doAddComponent(BlockComponent.Constructor<T> constructor) {
        BlockComponent component = (BlockComponent)constructor.create(this);
        this.components.add(component);
        return (T)component;
    }

    protected final <T extends BlockComponent.WithoutData> T addComponent(BlockComponent.Constructor<T> constructor) {
        return (T)((BlockComponent.WithoutData)this.doAddComponent(constructor));
    }

    protected final Iterable<BlockComponent> getComponents() {
        return this.components;
    }

    @Override
    public final TKBlock getBlock() {
        return this;
    }

    public final Component getDefaultContainerName() {
        ResourceLocation name = this.getRegistryName();
        return new TranslatableComponent("container." + name.m_135827_() + "." + name.m_135815_());
    }

    protected final InteractionResult openMenu(Level level, Player player, MenuConstructor constructor) {
        return this.openMenu(level, player, constructor, this.getDefaultContainerName());
    }

    protected final InteractionResult openMenu(Level level, Player player, MenuConstructor constructor, Component title) {
        if (!level.m_5776_()) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider(constructor, title));
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        for (BlockComponent component : this.getComponents()) {
            InteractionResult result = component.use(state, level, pos, player, hand, hit);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        for (BlockComponent component : this.getComponents()) {
            component.onRemove(state, level, pos, newState, moving);
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        int signal = 0;
        for (BlockComponent component : this.getComponents()) {
            signal = Math.max(signal, component.getAnalogOutputSignal(state, level, pos));
        }
        return signal;
    }

    public static class WithEntity
    extends TKBlock
    implements EntityBlock {
        final RegistryObject<BlockEntityType<TKBlockEntity>> entityType;
        final Map<String, BlockComponent.WithData> components = new HashMap<String, BlockComponent.WithData>();

        public WithEntity(BlockBehaviour.Properties properties, RegistryObject<BlockEntityType<TKBlockEntity>> entityType) {
            super(properties);
            this.entityType = entityType;
        }

        protected final <T extends BlockComponent.WithData<?>> T addComponent(String name, BlockComponent.Constructor<T> constructor) {
            BlockComponent.WithData component = (BlockComponent.WithData)this.doAddComponent(constructor);
            this.components.put(name, component);
            return (T)component;
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return ((BlockEntityType)this.entityType.get()).m_155264_(pos, state);
        }
    }
}

