/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block;

import com.google.common.collect.ImmutableMap;
import com.technicalitiesmc.lib.block.BlockComponent;
import com.technicalitiesmc.lib.block.BlockComponentData;
import com.technicalitiesmc.lib.block.TKBlock;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public final class TKBlockEntity
extends BlockEntity {
    private final Context context = new Context();
    private final Map<String, BlockComponentData> namedData;
    private final Map<BlockComponent, BlockComponentData> componentData;

    public TKBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, (TKBlock.WithEntity)state.m_60734_());
    }

    private TKBlockEntity(BlockPos pos, BlockState state, TKBlock.WithEntity block) {
        super((BlockEntityType)block.entityType.get(), pos, state);
        ImmutableMap.Builder namedData = ImmutableMap.builder();
        ImmutableMap.Builder componentData = ImmutableMap.builder();
        block.components.forEach((name, component) -> {
            Object data = component.createData(this.context);
            namedData.put(name, data);
            componentData.put(component, data);
        });
        this.namedData = namedData.build();
        this.componentData = componentData.build();
    }

    public <T extends BlockComponentData> T get(BlockComponent.WithData<T> component) {
        return (T)this.componentData.get(component);
    }

    public void onLoad() {
        super.onLoad();
        for (BlockComponentData data : this.componentData.values()) {
            data.onLoad();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        for (BlockComponentData data : this.componentData.values()) {
            data.onChunkUnloaded();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        for (BlockComponentData data : this.componentData.values()) {
            data.onRemoved();
        }
    }

    @Nonnull
    public IModelData getModelData() {
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        for (BlockComponentData data : this.componentData.values()) {
            data.addModelData(builder);
        }
        return builder.build();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        for (BlockComponentData data : this.componentData.values()) {
            LazyOptional<T> result = data.getCapability(cap, side);
            if (!result.isPresent()) continue;
            return result;
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        for (BlockComponentData data : this.componentData.values()) {
            data.invalidateCaps();
        }
        super.invalidateCaps();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag componentsTag = new CompoundTag();
        this.namedData.forEach((name, data) -> componentsTag.m_128365_(name, (Tag)data.save(new CompoundTag())));
        tag.m_128365_("components", (Tag)componentsTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        CompoundTag componentsTag = tag.m_128469_("components");
        this.namedData.forEach((name, data) -> data.load(componentsTag.m_128469_(name)));
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        CompoundTag componentsTag = new CompoundTag();
        this.namedData.forEach((name, data) -> componentsTag.m_128365_(name, (Tag)data.saveDescription(new CompoundTag())));
        tag.m_128365_("components", (Tag)componentsTag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        CompoundTag componentsTag = tag.m_128469_("components");
        this.namedData.forEach((name, data) -> data.loadDescription(componentsTag.m_128469_(name)));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, e -> e.m_5995_());
    }

    private class Context
    implements BlockComponentData.Context {
        private Context() {
        }

        @Override
        public Level getLevel() {
            return TKBlockEntity.this.m_58904_();
        }

        @Override
        public BlockPos getBlockPos() {
            return TKBlockEntity.this.m_58899_();
        }

        @Override
        public BlockState getBlockState() {
            return TKBlockEntity.this.m_58900_();
        }

        @Override
        public void markUnsaved() {
            BlockPos pos;
            Level level = this.getLevel();
            if (level.m_46805_(pos = this.getBlockPos())) {
                level.m_46745_(pos).m_8092_(true);
            }
        }

        @Override
        public void updateComparators() {
            this.getLevel().m_46717_(this.getBlockPos(), this.getBlockState().m_60734_());
        }

        @Override
        public void markDataUpdated() {
            TKBlockEntity.this.requestModelDataUpdate();
        }
    }
}

