/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block.component;

import com.technicalitiesmc.lib.block.BlockComponent;
import com.technicalitiesmc.lib.block.BlockComponentData;
import com.technicalitiesmc.lib.inventory.ItemHolder;
import com.technicalitiesmc.lib.inventory.SerializableItemHolder;
import com.technicalitiesmc.lib.inventory.SimpleItemHolder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class BlockInventory
extends BlockComponent.WithData<Data> {
    private static final Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    private final boolean shouldDropItemsOnBreak;

    public BlockInventory(BlockComponent.Context context, int slots, Flag ... flags) {
        this(context, slots, flags.length != 0 ? EnumSet.copyOf(Arrays.asList(flags)) : EnumSet.noneOf(Flag.class));
    }

    public BlockInventory(BlockComponent.Context context, int slots, EnumSet<Flag> flags) {
        this(context, (Runnable callback) -> new SimpleItemHolder(slots, callback), flags);
    }

    public BlockInventory(BlockComponent.Context context, InventoryFactory inventoryFactory, Flag ... flags) {
        this(context, inventoryFactory, EnumSet.copyOf(Arrays.asList(flags)));
    }

    public BlockInventory(BlockComponent.Context context, InventoryFactory inventoryFactory, EnumSet<Flag> flags) {
        super(context, ctx -> new Data(ctx, inventoryFactory, flags));
        this.shouldDropItemsOnBreak = flags.contains((Object)Flag.DROP_ON_BREAK);
    }

    public ItemHolder at(BlockGetter level, BlockPos pos, BlockState state) {
        return ((Data)this.getData((BlockGetter)level, (BlockPos)pos, (BlockState)state)).inventory;
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (this.shouldDropItemsOnBreak && !state.m_60713_(newState.m_60734_())) {
            Data data = (Data)this.getData((BlockGetter)level, pos, state);
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)data.inventory.asVanillaContainer());
            level.m_46717_(pos, (Block)this.getBlock());
        }
    }

    @Override
    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        Data data = (Data)this.getData((BlockGetter)level, pos, state);
        return AbstractContainerMenu.m_38938_((Container)data.inventory.asVanillaContainer());
    }

    public static enum Flag {
        COMPARATOR_OUTPUT,
        DROP_ON_BREAK,
        EXPOSE_ITEM_HANDLER;

    }

    @FunctionalInterface
    public static interface InventoryFactory {
        public SerializableItemHolder createInventory(Runnable var1);
    }

    public static class Data
    extends BlockComponentData {
        private final boolean shouldUpdateComparators;
        private final boolean shouldExposeCaps;
        private final SerializableItemHolder inventory;
        private final LazyOptional<IItemHandler> itemHandler;

        private Data(BlockComponentData.Context context, InventoryFactory inventoryFactory, EnumSet<Flag> flags) {
            super(context);
            this.shouldUpdateComparators = flags.contains((Object)Flag.COMPARATOR_OUTPUT);
            this.shouldExposeCaps = flags.contains((Object)Flag.EXPOSE_ITEM_HANDLER);
            this.inventory = inventoryFactory.createInventory(this::onInventoryUpdate);
            this.itemHandler = this.shouldExposeCaps ? LazyOptional.of(this.inventory::asItemHandler) : LazyOptional.empty();
        }

        private void onInventoryUpdate() {
            this.markUnsaved();
            if (this.shouldUpdateComparators) {
                this.updateComparators();
            }
        }

        @Override
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (this.shouldExposeCaps && cap == ITEM_HANDLER_CAPABILITY) {
                return this.itemHandler.cast();
            }
            return super.getCapability(cap, side);
        }

        @Override
        public void invalidateCaps() {
            this.itemHandler.invalidate();
        }

        @Override
        public CompoundTag save(CompoundTag tag) {
            tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            return tag;
        }

        @Override
        public void load(CompoundTag tag) {
            this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        }
    }
}

