/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.circuit.component;

import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.CircuitEventFlags;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import java.util.EnumMap;
import java.util.Map;

public class ComponentEventMap {
    private static final ComponentEventMap EMPTY = new ComponentEventMap(new EnumMap<VecDirection, CircuitEventFlags>(VecDirection.class));
    private final EnumMap<VecDirection, CircuitEventFlags> flags;

    public static ComponentEventMap empty() {
        return EMPTY;
    }

    private ComponentEventMap(EnumMap<VecDirection, CircuitEventFlags> flags) {
        this.flags = flags;
    }

    public CircuitEventFlags get(VecDirection side) {
        return this.flags.getOrDefault((Object)side, CircuitEventFlags.none());
    }

    public boolean hasAny(VecDirection side, CircuitEvent ... events) {
        return this.get(side).hasAny(events);
    }

    public VecDirectionFlags findAny(CircuitEvent ... events) {
        return this.findAny(VecDirectionFlags.all(), events);
    }

    public VecDirectionFlags findAny(VecDirectionFlags mask, CircuitEvent ... events) {
        return VecDirectionFlags.of((VecDirection[])this.flags.entrySet().stream().filter(e -> mask.has((VecDirection)((Object)((Object)e.getKey()))) && ((CircuitEventFlags)e.getValue()).hasAny(events)).map(Map.Entry::getKey).toArray(VecDirection[]::new));
    }

    public byte[] serialize() {
        byte[] bytes = new byte[VecDirection.VALUES.length];
        for (VecDirection side : VecDirection.VALUES) {
            bytes[side.ordinal()] = this.get(side).serialize();
        }
        return bytes;
    }

    public static class Builder {
        private final EnumMap<VecDirection, CircuitEventFlags> flags = new EnumMap(VecDirection.class);

        public void add(VecDirection side, CircuitEventFlags events) {
            this.flags.compute(side, ($, current) -> current != null ? current.and(events) : events);
        }

        public void add(VecDirection side, CircuitEvent ... events) {
            this.add(side, CircuitEventFlags.of(events));
        }

        public void add(VecDirectionFlags sides, CircuitEvent ... events) {
            sides.forEach(side -> this.add((VecDirection)((Object)side), events));
        }

        public boolean isEmpty() {
            return this.flags.isEmpty();
        }

        public ComponentEventMap build() {
            return new ComponentEventMap(this.flags);
        }

        public static Builder deserialize(byte[] bytes) {
            Builder builder = new Builder();
            for (VecDirection side : VecDirection.VALUES) {
                builder.add(side, CircuitEventFlags.deserialize(bytes[side.ordinal()]));
            }
            return builder;
        }
    }
}

