/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.circuit.component;

import com.google.common.base.Suppliers;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentStateBuilder;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.registries.ForgeRegistryEntry;

public final class ComponentType
extends ForgeRegistryEntry<ComponentType> {
    private final Factory factory;
    private final ClientComponent clientComponent;
    private final ComponentSlot slot;
    private final ComponentSlot[] allSlots;
    private final Supplier<ResourceLocation> lootTable = Suppliers.memoize(() -> {
        ResourceLocation name = this.getRegistryName();
        return new ResourceLocation(name.m_135827_(), "scmcomponents/" + name.m_135815_());
    });
    private final StateDefinition<ComponentType, ComponentState> stateDefinition;
    private final ComponentState defaultState;

    public ComponentType(Factory factory, StateBuilder stateBuilder, ClientComponent clientComponent, ComponentSlot slot, ComponentSlot ... additionalSlots) {
        this.factory = factory;
        this.clientComponent = clientComponent;
        this.slot = slot;
        this.allSlots = Arrays.copyOf(additionalSlots, additionalSlots.length + 1);
        this.allSlots[additionalSlots.length] = slot;
        ComponentStateBuilder builder = new ComponentStateBuilder(this);
        stateBuilder.createStateDefinition(builder);
        this.stateDefinition = builder.create();
        this.defaultState = (ComponentState)this.stateDefinition.m_61090_();
    }

    public CircuitComponent create(ComponentContext context) {
        return this.factory.create(context);
    }

    public ClientComponent getClientComponent() {
        return this.clientComponent;
    }

    public StateDefinition<ComponentType, ComponentState> getStateDefinition() {
        return this.stateDefinition;
    }

    public ComponentState getDefaultState() {
        return this.defaultState;
    }

    public ComponentSlot getSlot() {
        return this.slot;
    }

    public ComponentSlot[] getAllSlots() {
        return this.allSlots;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable.get();
    }

    public String toString() {
        return "ComponentType[" + this.getRegistryName() + "]";
    }

    @FunctionalInterface
    public static interface Factory {
        public CircuitComponent create(ComponentContext var1);
    }

    @FunctionalInterface
    public static interface StateBuilder {
        public void createStateDefinition(ComponentStateBuilder var1);
    }
}

