/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.inventory;

import com.technicalitiesmc.lib.inventory.ItemHolder;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandlerAdapter
implements IItemHandler {
    private final ItemHolder inventory;

    public ItemHandlerAdapter(ItemHolder inventory) {
        this.inventory = inventory;
    }

    public int getSlots() {
        return this.inventory.getSize();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack currentStack = this.inventory.get(slot);
        if (!currentStack.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)currentStack, (ItemStack)stack)) {
            return stack;
        }
        if (currentStack.m_41619_()) {
            if (!simulate) {
                this.inventory.set(slot, stack);
            }
            return ItemStack.f_41583_;
        }
        int maxSize = currentStack.m_41741_();
        int currentSize = currentStack.m_41613_();
        int inserted = Math.min(maxSize - currentSize, stack.m_41613_());
        if (!simulate) {
            currentStack.m_41769_(inserted);
        }
        ItemStack leftover = stack.m_41777_();
        leftover.m_41774_(inserted);
        return leftover;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extracted = this.inventory.get(slot);
        if (extracted.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            extracted = extracted.m_41777_();
        }
        return extracted.m_41620_(amount);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }
}

