/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.inventory;

import com.technicalitiesmc.lib.inventory.ItemHolder;
import com.technicalitiesmc.lib.inventory.SerializableItemHolder;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class SimpleItemHolder
implements SerializableItemHolder,
INBTSerializable<CompoundTag> {
    private final NonNullList<ItemStack> items;
    @Nullable
    private final Runnable updateCallback;

    public SimpleItemHolder(int size, Runnable updateCallback) {
        this.items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.updateCallback = updateCallback;
    }

    public SimpleItemHolder(int size) {
        this(size, null);
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public ItemStack get(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @Override
    public void set(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    public ItemHolder slice(int fromIncluding, int toExcluding) {
        return new Slice(fromIncluding, toExcluding - fromIncluding);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag slotList = new ListTag();
        for (ItemStack slot : this.items) {
            slotList.add((Object)slot.serializeNBT());
        }
        tag.m_128365_("slots", (Tag)slotList);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        ListTag slotList = tag.m_128437_("slots", 10);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.m_41712_((CompoundTag)slotList.m_128728_(i)));
        }
    }

    public static SimpleItemHolder from(NonNullList<ItemStack> items) {
        SimpleItemHolder inventory = new SimpleItemHolder(items.size());
        for (int i = 0; i < items.size(); ++i) {
            inventory.set(i, ((ItemStack)items.get(i)).m_41777_());
        }
        return inventory;
    }

    private class Slice
    implements ItemHolder {
        private final int from;
        private final int size;

        public Slice(int from, int size) {
            this.from = from;
            this.size = size;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public ItemStack get(int slot) {
            return SimpleItemHolder.this.get(slot + this.from);
        }

        @Override
        public void set(int slot, ItemStack stack) {
            SimpleItemHolder.this.set(slot + this.from, stack);
        }

        @Override
        public void clear() {
            for (int i = 0; i < SimpleItemHolder.this.items.size(); ++i) {
                SimpleItemHolder.this.items.set(i + this.from, (Object)ItemStack.f_41583_);
            }
            if (SimpleItemHolder.this.updateCallback != null) {
                SimpleItemHolder.this.updateCallback.run();
            }
        }

        @Override
        public ItemHolder slice(int fromIncluding, int toExcluding) {
            return new Slice(this.from + fromIncluding, toExcluding - fromIncluding);
        }
    }
}

