/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class TKItem
extends Item {
    private static final Capability<DataStore> DATA_STORE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<DataStore>(){});
    private final List<DataHandle<?>> dataClasses = new ArrayList();
    private final Map<Capability, Function<ItemStack, ? extends LazyOptional>> capabilitySuppliers = new HashMap<Capability, Function<ItemStack, ? extends LazyOptional>>();

    public TKItem(Item.Properties properties) {
        super(properties);
    }

    protected final <T extends INBTSerializable<CompoundTag>> DataHandle<T> addData(String name, DataFactory<T> factory) {
        return this.addData(name, INBTSerializable::serializeNBT, (stack, saveCallback, tag) -> {
            INBTSerializable instance = (INBTSerializable)factory.create(stack, saveCallback);
            instance.deserializeNBT((Tag)tag);
            return instance;
        });
    }

    protected final <T> DataHandle<T> addData(String name, DataSerializer<T> serializer, DataDeserializer<T> deserializer) {
        DataHandle<T> handle = new DataHandle<T>(name, serializer, deserializer);
        this.dataClasses.add(handle);
        return handle;
    }

    protected final <T> void addCapability(Capability<T> capability, Function<ItemStack, LazyOptional<T>> supplier) {
        this.capabilitySuppliers.put(capability, supplier);
    }

    protected final InteractionResultHolder<ItemStack> openMenu(Level level, Player player, ItemStack stack, MenuConstructor constructor) {
        return this.openMenu(level, player, stack, constructor, this.getDefaultContainerName());
    }

    protected final InteractionResultHolder<ItemStack> openMenu(Level level, Player player, ItemStack stack, MenuConstructor constructor, Component title) {
        if (!level.m_5776_()) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider(constructor, title));
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        final LazyOptional dataStore = LazyOptional.of(() -> new DataStore(stack));
        final HashMap capabilityCache = new HashMap();
        return new ICapabilityProvider(){

            private <T> LazyOptional<T> computeCached(Capability<T> capability) {
                Function<ItemStack, ? extends LazyOptional> supplier = TKItem.this.capabilitySuppliers.get(capability);
                return supplier != null ? supplier.apply(stack) : null;
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
                if (capability == DATA_STORE_CAPABILITY) {
                    return dataStore.cast();
                }
                LazyOptional<T> customCap = TKItem.this.getCapability(stack, capability);
                if (customCap.isPresent()) {
                    return customCap;
                }
                LazyOptional cached = capabilityCache.computeIfAbsent(capability, this::computeCached);
                return cached != null ? cached : LazyOptional.empty();
            }
        };
    }

    protected <T> LazyOptional<T> getCapability(ItemStack stack, Capability<T> capability) {
        return LazyOptional.empty();
    }

    public final Component getDefaultContainerName() {
        ResourceLocation name = this.getRegistryName();
        return new TranslatableComponent("container." + name.m_135827_() + "." + name.m_135815_());
    }

    @FunctionalInterface
    public static interface DataSerializer<T> {
        public CompoundTag serialize(T var1);
    }

    @FunctionalInterface
    public static interface DataFactory<T> {
        public T create(ItemStack var1, Runnable var2);
    }

    @FunctionalInterface
    public static interface DataDeserializer<T> {
        public T deserialize(ItemStack var1, Runnable var2, CompoundTag var3);
    }

    public class DataHandle<T> {
        private final String name;
        private final DataSerializer<T> serializer;
        private final DataDeserializer<T> deserializer;

        private DataHandle(String name, DataSerializer<T> serializer, DataDeserializer<T> deserializer) {
            this.name = name;
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        public T of(ItemStack stack) {
            return ((DataStore)stack.getCapability(DATA_STORE_CAPABILITY).orElse(null)).get(this);
        }

        public void save(ItemStack stack) {
            ((DataStore)stack.getCapability(DATA_STORE_CAPABILITY).orElse(null)).save(this);
        }
    }

    public class DataStore {
        private final ItemStack stack;
        private final Map<DataHandle, Object> instances = new HashMap<DataHandle, Object>();

        private DataStore(ItemStack stack) {
            this.stack = stack;
        }

        protected <T> T get(DataHandle<T> handle) {
            return (T)this.instances.computeIfAbsent(handle, h -> h.deserializer.deserialize(this.stack, () -> this.save((DataHandle)h), this.stack.m_41698_("d_" + h.name)));
        }

        protected <T> void save(DataHandle<T> handle) {
            Object data = this.instances.get(handle);
            if (data != null) {
                this.stack.m_41700_("d_" + handle.name, (Tag)handle.serializer.serialize(data));
            }
        }
    }
}

