/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.math;

import com.google.common.collect.ImmutableList;
import com.technicalitiesmc.lib.math.CustomShape;
import com.technicalitiesmc.lib.math.IndexedBlockHitResult;
import com.technicalitiesmc.lib.math.IndexedShape;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MergedShape
extends CustomShape {
    private final ImmutableList<VoxelShape> shapes;

    private static VoxelShape merge(Stream<VoxelShape> shapes) {
        return shapes.filter(Objects::nonNull).map(MergedShape::unwrap).reduce((a, b) -> Shapes.m_83113_((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.f_82695_)).map(VoxelShape::m_83296_).orElse(Shapes.m_83040_());
    }

    public static MergedShape ofMerged(VoxelShape ... shapes) {
        return MergedShape.of(MergedShape.merge(Arrays.stream(shapes)), shapes);
    }

    public static MergedShape of(VoxelShape baseShape, VoxelShape ... shapes) {
        return MergedShape.of(baseShape, (ImmutableList<VoxelShape>)ImmutableList.copyOf((Object[])shapes));
    }

    public static MergedShape ofMerged(List<VoxelShape> shapes) {
        return MergedShape.of(MergedShape.merge(shapes.stream()), (ImmutableList<VoxelShape>)ImmutableList.copyOf(shapes));
    }

    public static MergedShape of(VoxelShape baseShape, List<VoxelShape> shapes) {
        return MergedShape.of(baseShape, (ImmutableList<VoxelShape>)ImmutableList.copyOf(shapes));
    }

    public static MergedShape ofMerged(ImmutableList<VoxelShape> shapes) {
        return MergedShape.of(MergedShape.merge(shapes.stream()), shapes);
    }

    public static MergedShape of(VoxelShape baseShape, ImmutableList<VoxelShape> shapes) {
        return new MergedShape(shapes, baseShape);
    }

    private static VoxelShape unwrap(VoxelShape shape) {
        return shape instanceof CustomShape ? ((CustomShape)shape).parent : shape;
    }

    private MergedShape(ImmutableList<VoxelShape> shapes, VoxelShape merged) {
        super(merged);
        this.shapes = shapes;
    }

    public ImmutableList<VoxelShape> getShapes() {
        return this.shapes;
    }

    public Optional<IndexedShape> find(int index) {
        return this.shapes.stream().filter(s -> {
            IndexedShape is;
            return s instanceof IndexedShape && (is = (IndexedShape)((Object)s)).getIndex() == index;
        }).map(s -> (IndexedShape)((Object)s)).findFirst();
    }

    @Override
    @Nullable
    public BlockHitResult m_83220_(Vec3 start, Vec3 end, BlockPos pos) {
        BlockHitResult closest = null;
        double closestDist = Double.POSITIVE_INFINITY;
        for (VoxelShape shape : this.shapes) {
            BlockHitResult blockHitResult;
            double d;
            BlockHitResult hit = shape.m_83220_(start, end, pos);
            if (hit == null || hit.m_6662_() == HitResult.Type.MISS) continue;
            double dist = hit.m_82450_().m_82557_(start);
            if (d > closestDist) continue;
            if (hit instanceof IndexedBlockHitResult) {
                blockHitResult = hit;
            } else {
                int n;
                if (shape instanceof IndexedShape) {
                    IndexedShape is = (IndexedShape)shape;
                    n = is.getIndex();
                } else {
                    n = Integer.MAX_VALUE;
                }
                blockHitResult = new IndexedBlockHitResult(hit, shape, n);
            }
            closest = blockHitResult;
            closestDist = dist;
        }
        return closest;
    }
}

