/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.network;

import com.technicalitiesmc.lib.network.Packet;
import com.technicalitiesmc.lib.network.ServerboundGhostSlotClickPacket;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class TKLibNetworkHandler {
    private static SimpleChannel INSTANCE;
    private static int ID;

    public static void registerPackets() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("tklib", "main"), () -> "1.0", s -> true, s -> true);
        TKLibNetworkHandler.register(ServerboundGhostSlotClickPacket.class, ServerboundGhostSlotClickPacket::new);
    }

    private static <T extends Packet> void register(Class<T> type, Function<FriendlyByteBuf, T> decoder) {
        INSTANCE.messageBuilder(type, ID++).encoder(Packet::encode).decoder(decoder).consumer((first, second) -> first.handle((NetworkEvent.Context)second.get())).add();
    }

    private static void sendToClient(Packet packet, ServerPlayer player) {
        INSTANCE.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static void sendToServer(Packet packet) {
        INSTANCE.sendToServer((Object)packet);
    }

    public static void sendServerboundGhostSlotClick(int slotNumber) {
        TKLibNetworkHandler.sendToServer(new ServerboundGhostSlotClickPacket(slotNumber));
    }

    static {
        ID = 0;
    }
}

