/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.util;

import java.util.Arrays;
import java.util.stream.Stream;

public abstract class AbstractFlags8<T extends Enum<T>, F extends AbstractFlags8<T, F>> {
    private final byte value;

    public static byte makeMask(Enum<?> value) {
        return (byte)(1 << value.ordinal());
    }

    public static byte makeMask(Enum<?> ... values) {
        byte value = 0;
        for (Enum<?> val : values) {
            value = (byte)(value | AbstractFlags8.makeMask(val));
        }
        return value;
    }

    protected AbstractFlags8(byte value) {
        this.value = value;
    }

    protected final byte getValue() {
        return this.value;
    }

    protected abstract F create(byte var1);

    public boolean isEmpty() {
        return this.value == 0;
    }

    public boolean has(T val) {
        return (this.value & AbstractFlags8.makeMask(val)) != 0;
    }

    public boolean hasAny(T ... values) {
        return (this.value & AbstractFlags8.makeMask(values)) != 0;
    }

    public boolean hasAny(F values) {
        return (this.value & ((AbstractFlags8)values).getValue()) != 0;
    }

    public boolean hasAll(T ... values) {
        byte mask = AbstractFlags8.makeMask(values);
        return (this.value & mask) == mask;
    }

    public boolean hasAll(F values) {
        byte mask = ((AbstractFlags8)values).getValue();
        return (this.value & mask) == mask;
    }

    public F and(T val) {
        return this.create((byte)(this.value | AbstractFlags8.makeMask(val)));
    }

    public F and(T ... values) {
        return this.create((byte)(this.value | AbstractFlags8.makeMask(values)));
    }

    public F and(F values) {
        return this.create((byte)(this.value | ((AbstractFlags8)values).getValue()));
    }

    public F except(T val) {
        return this.create((byte)(this.value & ~AbstractFlags8.makeMask(val)));
    }

    public F except(T ... values) {
        return this.create((byte)(this.value & ~AbstractFlags8.makeMask(values)));
    }

    public F except(F values) {
        return this.create((byte)(this.value & ~((AbstractFlags8)values).getValue()));
    }

    public F onlyIn(T val) {
        return this.create((byte)(this.value & AbstractFlags8.makeMask(val)));
    }

    public final F onlyIn(T ... values) {
        return this.create((byte)(this.value & AbstractFlags8.makeMask(values)));
    }

    public F onlyIn(F values) {
        return this.create((byte)(this.value & ((AbstractFlags8)values).getValue()));
    }

    public Stream<T> stream(Class<T> clazz) {
        return Arrays.stream((Enum[])clazz.getEnumConstants()).filter(this::has);
    }

    public byte serialize() {
        return this.value;
    }
}

