/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.util;

import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.util.DyeHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.ArrayUtils;

public class Utils {
    private static final Capability<DyeHolder> DYE_HOLDER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<DyeHolder>(){});

    public static byte set(byte value, int position, boolean state) {
        if (state) {
            return (byte)(value | 1 << position);
        }
        return (byte)(value & ~(1 << position));
    }

    public static VecDirection calculatePlanarDirection(float x, float z) {
        if (Math.abs(x) > Math.abs(z)) {
            return x > 0.0f ? VecDirection.POS_X : VecDirection.NEG_X;
        }
        return z > 0.0f ? VecDirection.POS_Z : VecDirection.NEG_Z;
    }

    public static <T> T cycle(T[] arr, T current) {
        int currentIdx = ArrayUtils.indexOf((Object[])arr, current);
        int idx = (currentIdx + 1) % arr.length;
        return arr[idx];
    }

    public static <T> T cycleConditionally(T[] arr, T current, Predicate<T> predicate) {
        int currentIdx = ArrayUtils.indexOf((Object[])arr, current);
        for (int i = 0; i < arr.length - 1; ++i) {
            int idx = (currentIdx + i + 1) % arr.length;
            T candidate = arr[idx];
            if (!predicate.test(candidate)) continue;
            return candidate;
        }
        return current;
    }

    public static <T> T[] rotateArray(T[] arr, Rotation rotation) {
        T[] newArr = Arrays.copyOf(arr, arr.length);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            newArr[rotation.m_55954_((Direction)direction).ordinal()] = arr[direction.ordinal()];
        }
        return newArr;
    }

    public static int[] rotateArray(int[] arr, Rotation rotation) {
        int[] newArr = Arrays.copyOf(arr, arr.length);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            newArr[rotation.m_55954_((Direction)direction).ordinal()] = arr[direction.ordinal()];
        }
        return newArr;
    }

    public static BlockState resolveHit(LevelAccessor level, BlockHitResult hit) {
        return level.m_8055_(hit.m_82425_());
    }

    public static <T> Set<T> newIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    @Nullable
    public static DyeColor getDyeColor(ItemStack stack) {
        LazyOptional cap = stack.getCapability(DYE_HOLDER_CAPABILITY);
        if (cap.isPresent()) {
            return ((DyeHolder)cap.orElse(null)).getColor();
        }
        return DyeColor.getColor((ItemStack)stack);
    }
}

