/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.immersiveengineering.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.immersiveengineering.recipe.IERecipeJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.crafting.CraftingHelper;

public class SawmillRecipeJS
extends IERecipeJS {
    public List<Boolean> stripping = new ArrayList<Boolean>();
    public boolean hasStripped = false;

    public void create(ListJS args) {
        this.outputItems.add(this.parseResultItem(args.get(0)));
        this.inputItems.add(this.parseIngredientItem(args.get(1)).asIngredientStack());
        if (args.size() >= 3) {
            for (Object o : ListJS.orSelf((Object)args.get(2))) {
                MapJS m = MapJS.of(o);
                if (m != null && m.containsKey((Object)"stripping") && m.containsKey((Object)"output")) {
                    this.outputItems.add(this.parseResultItem(m.get((Object)"output")));
                    this.stripping.add((Boolean)m.get((Object)"stripping"));
                    continue;
                }
                this.outputItems.add(this.parseResultItem(o));
                this.stripping.add(false);
            }
        }
        if (args.size() >= 4) {
            this.outputItems.add(this.parseResultItem(args.get(3)));
            this.hasStripped = true;
        }
        this.json.addProperty("energy", (Number)1600);
    }

    public void deserialize() {
        this.outputItems.add(this.parseResultItem(this.json.get("result")));
        if (this.json.has("secondaries")) {
            for (JsonElement element : this.json.get("secondaries").getAsJsonArray()) {
                ItemStackJS stack;
                JsonObject secondary = element.getAsJsonObject();
                if (!CraftingHelper.processConditions((JsonObject)secondary, (String)"conditions") || (stack = this.parseResultItem(secondary.get("output"))).isEmpty()) continue;
                if (secondary.has("chance")) {
                    stack.setChance(secondary.get("chance").getAsDouble());
                }
                this.outputItems.add(stack);
                this.stripping.add(secondary.has("stripping") && secondary.get("stripping").getAsBoolean());
            }
        }
        this.inputItems.add(this.parseIngredientItemIE(this.json.get("input")));
    }

    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("result", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
            JsonArray secondaries = new JsonArray();
            for (int i = 1; i < this.outputItems.size() - (this.hasStripped ? 1 : 0); ++i) {
                JsonObject o = new JsonObject();
                ItemStackJS is = ((ItemStackJS)this.outputItems.get(i)).copy();
                o.addProperty("stripping", this.stripping.get(i - 1));
                o.add("output", is.toResultJson());
                secondaries.add((JsonElement)o);
            }
            this.json.add("secondaries", (JsonElement)secondaries);
            if (this.hasStripped) {
                this.json.add("stripped", ((ItemStackJS)this.outputItems.get(this.outputItems.size() - 1)).toResultJson());
            }
        }
        if (this.serializeInputs) {
            this.json.add("input", ((IngredientJS)this.inputItems.get(0)).toJson());
        }
    }
}

