/*
 * Decompiled with CFR 0.152.
 */
package mod.grimmauld.windowlogging;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import mod.grimmauld.windowlogging.WindowBlockColor;
import mod.grimmauld.windowlogging.WindowInABlockBlock;
import mod.grimmauld.windowlogging.WindowInABlockModel;
import mod.grimmauld.windowlogging.WindowInABlockTileEntity;
import mod.grimmauld.windowlogging.WindowInABlockTileEntityRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="windowlogging", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DeferredRegistries {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"windowlogging");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"windowlogging");
    public static final RegistryObject<WindowInABlockBlock> WINDOW_IN_A_BLOCK = DeferredRegistries.registerBlock("window_in_a_block", WindowInABlockBlock::new);
    public static final RegistryObject<BlockEntityType<WindowInABlockTileEntity>> WINDOW_IN_A_BLOCK_TILE_ENTITY;

    private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerTE(String id, Supplier<BlockEntityType.Builder<T>> type) {
        return BLOCK_ENTITY_TYPES.register(id, () -> ((BlockEntityType.Builder)type.get()).m_58966_(null));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String id, Supplier<T> blockSupplier) {
        return BLOCKS.register(id, blockSupplier);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)WINDOW_IN_A_BLOCK.get()), renderType -> true);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)WINDOW_IN_A_BLOCK_TILE_ENTITY.get()), WindowInABlockTileEntityRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerColorProviders(ParticleFactoryRegisterEvent event) {
        WindowBlockColor.registerFor((WindowInABlockBlock)WINDOW_IN_A_BLOCK.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        ((WindowInABlockBlock)WINDOW_IN_A_BLOCK.get()).m_49965_().m_61056_().stream().map(state -> Optional.ofNullable(((WindowInABlockBlock)WINDOW_IN_A_BLOCK.get()).getRegistryName()).map(rl -> new ModelResourceLocation(rl, BlockModelShaper.m_110887_((Map)state.m_61148_())))).flatMap(Optional::stream).forEach(location -> modelRegistry.put(location, new WindowInABlockModel((BakedModel)modelRegistry.get(location))));
    }

    static {
        BLOCK_ENTITY_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        WINDOW_IN_A_BLOCK_TILE_ENTITY = DeferredRegistries.registerTE("window_in_a_block", () -> BlockEntityType.Builder.m_155273_(WindowInABlockTileEntity::new, (Block[])new Block[]{Blocks.f_50256_, (Block)WINDOW_IN_A_BLOCK.get()}));
    }
}

