/*
 * Decompiled with CFR 0.152.
 */
package mod.grimmauld.windowlogging;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mod.grimmauld.windowlogging.WindowInABlockTileEntity;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IBlockRenderProperties;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.common.ForgeMod;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WindowInABlockBlock
extends IronBarsBlock
implements EntityBlock {
    public WindowInABlockBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60955_());
    }

    private static void addBlockHitEffects(ParticleEngine manager, BlockPos pos, BlockHitResult target, BlockState blockstate, ClientLevel world) {
        VoxelShape shape = blockstate.m_60808_((BlockGetter)world, pos);
        if (shape.m_83281_()) {
            return;
        }
        Direction side = target.m_82434_();
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        AABB axisalignedbb = shape.m_83215_();
        double d0 = (double)i + manager.f_107292_.nextDouble() * (axisalignedbb.f_82291_ - axisalignedbb.f_82288_ - (double)0.2f) + (double)0.1f + axisalignedbb.f_82288_;
        double d1 = (double)j + manager.f_107292_.nextDouble() * (axisalignedbb.f_82292_ - axisalignedbb.f_82289_ - (double)0.2f) + (double)0.1f + axisalignedbb.f_82289_;
        double d2 = (double)k + manager.f_107292_.nextDouble() * (axisalignedbb.f_82293_ - axisalignedbb.f_82290_ - (double)0.2f) + (double)0.1f + axisalignedbb.f_82290_;
        if (side == Direction.DOWN) {
            d1 = (double)j + axisalignedbb.f_82289_ - (double)0.1f;
        }
        if (side == Direction.UP) {
            d1 = (double)j + axisalignedbb.f_82292_ + (double)0.1f;
        }
        if (side == Direction.NORTH) {
            d2 = (double)k + axisalignedbb.f_82290_ - (double)0.1f;
        }
        if (side == Direction.SOUTH) {
            d2 = (double)k + axisalignedbb.f_82293_ + (double)0.1f;
        }
        if (side == Direction.WEST) {
            d0 = (double)i + axisalignedbb.f_82288_ - (double)0.1f;
        }
        if (side == Direction.EAST) {
            d0 = (double)i + axisalignedbb.f_82291_ + (double)0.1f;
        }
        manager.m_107344_(new TerrainParticle(world, d0, d1, d2, 0.0, 0.0, 0.0, blockstate, pos).m_107268_(0.2f).m_6569_(0.6f));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        Vec3 start = player.m_20299_(1.0f);
        AttributeInstance reachDistanceAttribute = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachDistanceAttribute == null) {
            return super.onDestroyedByPlayer(state, world, pos, null, willHarvest, fluid);
        }
        Vec3 end = start.m_82549_(player.m_20154_().m_82490_(reachDistanceAttribute.m_22135_()));
        BlockHitResult target = world.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        WindowInABlockTileEntity tileEntity = this.getTileEntity((BlockGetter)world, pos);
        if (tileEntity == null) {
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        BlockState windowBlock = tileEntity.getWindowBlock();
        CompoundTag partialBlockTileData = tileEntity.getPartialBlockTileData();
        for (AABB bb : windowBlock.m_60808_((BlockGetter)world, pos).m_83299_()) {
            BlockEntity te;
            if (!bb.m_82400_(0.1).m_82390_(target.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) continue;
            windowBlock.m_60734_().m_5707_(world, pos, windowBlock, player);
            if (!player.m_7500_()) {
                Block.m_49881_((BlockState)windowBlock, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
            BlockState partialBlock = tileEntity.getPartialBlock();
            world.m_46597_(pos, partialBlock);
            for (Direction d : Direction.values()) {
                BlockPos offset = pos.m_142300_(d);
                BlockState otherState = world.m_8055_(offset);
                partialBlock = partialBlock.m_60728_(d, otherState, (LevelAccessor)world, pos, offset);
                world.m_7260_(offset, otherState, otherState, 2);
            }
            if (partialBlock != world.m_8055_(pos)) {
                world.m_46597_(pos, partialBlock);
            }
            if (world.m_8055_(pos) instanceof EntityBlock && (te = world.m_7702_(pos)) != null) {
                te.deserializeNBT(partialBlockTileData);
                te.m_6596_();
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getSurroundingBlockState(reader, pos).m_60631_(reader, pos);
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter world, BlockPos pos, Entity collidingEntity) {
        return this.getSurroundingBlockState(world, pos).collisionExtendsVertically(world, pos, collidingEntity);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        return this.getSurroundingBlockState(worldIn, pos).m_60625_(player, worldIn, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return this.getSurroundingBlockState(world, pos).getExplosionResistance(world, pos, explosion);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockState window = this.getWindowBlockState(world, pos);
        for (AABB bb : window.m_60808_(world, pos).m_83299_()) {
            if (!bb.m_82400_(0.1).m_82390_(target.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) continue;
            return window.getCloneItemStack(target, world, pos, player);
        }
        BlockState surrounding = this.getSurroundingBlockState(world, pos);
        return surrounding.getCloneItemStack(target, world, pos, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity tileentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (!(tileentity instanceof WindowInABlockTileEntity)) {
            return Collections.emptyList();
        }
        WindowInABlockTileEntity te = (WindowInABlockTileEntity)tileentity;
        BlockEntity partialTE = te.getPartialBlockTileEntityIfPresent();
        if (partialTE != null) {
            builder.m_78972_(LootContextParams.f_81462_, (Object)partialTE);
        }
        List drops = te.getPartialBlock().m_60724_(builder);
        builder.m_78972_(LootContextParams.f_81462_, (Object)tileentity);
        drops.addAll(te.getWindowBlock().m_60724_(builder));
        return drops;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape1 = this.getSurroundingBlockState(worldIn, pos).m_60651_(worldIn, pos, context);
        VoxelShape shape2 = this.getWindowBlockState(worldIn, pos).m_60651_(worldIn, pos, context);
        return Shapes.m_83110_((VoxelShape)shape1, (VoxelShape)shape2);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, worldIn, pos, context);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        WindowInABlockTileEntity te = this.getTileEntity((BlockGetter)worldIn, currentPos);
        if (te == null) {
            return stateIn;
        }
        te.setWindowBlock(te.getWindowBlock().m_60728_(facing, facingState, worldIn, currentPos, facingPos));
        BlockState blockState = te.getPartialBlock().m_60728_(facing, facingState, worldIn, currentPos, facingPos);
        if (blockState.m_60734_() instanceof CrossCollisionBlock) {
            for (BooleanProperty side : Arrays.asList(CrossCollisionBlock.f_52310_, CrossCollisionBlock.f_52309_, CrossCollisionBlock.f_52311_, CrossCollisionBlock.f_52312_)) {
                blockState = (BlockState)blockState.m_61124_((Property)side, (Comparable)Boolean.valueOf(false));
            }
            te.setPartialBlock(blockState);
        }
        te.requestModelDataUpdate();
        return stateIn;
    }

    public BlockState getSurroundingBlockState(BlockGetter reader, BlockPos pos) {
        WindowInABlockTileEntity te = this.getTileEntity(reader, pos);
        if (te != null) {
            return te.getPartialBlock();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public BlockState getWindowBlockState(BlockGetter reader, BlockPos pos) {
        WindowInABlockTileEntity te = this.getTileEntity(reader, pos);
        if (te != null) {
            return te.getWindowBlock();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    @Nullable
    private WindowInABlockTileEntity getTileEntity(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof WindowInABlockTileEntity) {
            WindowInABlockTileEntity wte = (WindowInABlockTileEntity)te;
            return wte;
        }
        return null;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        WindowInABlockTileEntity te = this.getTileEntity((BlockGetter)world, pos);
        return super.getSoundType(te != null ? te.getPartialBlock() : state, world, pos, entity);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel world, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        WindowInABlockTileEntity te = this.getTileEntity((BlockGetter)world, pos);
        if (te != null) {
            te.getWindowBlock().addLandingEffects(world, pos, state2, entity, numberOfParticles / 2);
            return te.getPartialBlock().addLandingEffects(world, pos, state2, entity, numberOfParticles / 2);
        }
        return false;
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        WindowInABlockTileEntity te = this.getTileEntity((BlockGetter)world, pos);
        if (te != null) {
            te.getWindowBlock().addRunningEffects(world, pos, entity);
            return te.getPartialBlock().addRunningEffects(world, pos, entity);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new IBlockRenderProperties(){
            private final ParticleEngine particleEngine;
            {
                this.particleEngine = Minecraft.m_91087_().f_91061_;
            }

            public boolean addHitEffects(BlockState state, Level world, HitResult target, ParticleEngine manager) {
                if (target.m_6662_() != HitResult.Type.BLOCK || !(target instanceof BlockHitResult) || !(world instanceof ClientLevel)) {
                    return false;
                }
                BlockPos pos = ((BlockHitResult)target).m_82425_();
                WindowInABlockTileEntity te = WindowInABlockBlock.this.getTileEntity((BlockGetter)world, pos);
                if (te != null) {
                    RenderProperties.get((BlockState)te.getWindowBlock()).addHitEffects(state, world, target, this.particleEngine);
                    WindowInABlockBlock.addBlockHitEffects(manager, pos, (BlockHitResult)target, te.getWindowBlock(), (ClientLevel)world);
                    return RenderProperties.get((BlockState)te.getPartialBlock()).addHitEffects(te.getPartialBlock(), world, target, this.particleEngine);
                }
                return false;
            }

            public boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager) {
                WindowInABlockTileEntity te = WindowInABlockBlock.this.getTileEntity((BlockGetter)world, pos);
                if (te != null) {
                    RenderProperties.get((BlockState)te.getWindowBlock()).addDestroyEffects(te.getWindowBlock(), world, pos, this.particleEngine);
                    manager.m_107355_(pos, te.getWindowBlock());
                    return RenderProperties.get((BlockState)te.getPartialBlock()).addDestroyEffects(te.getPartialBlock(), world, pos, manager);
                }
                return false;
            }
        });
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        WindowInABlockTileEntity te = this.getTileEntity(world, pos);
        if (te != null) {
            BlockState partialState = te.getPartialBlock();
            partialState.m_60734_().getLightEmission(partialState, world, pos);
        }
        return 0;
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        WindowInABlockTileEntity te = this.getTileEntity((BlockGetter)world, pos);
        if (te != null) {
            BlockState windowState = te.getWindowBlock();
            return windowState.m_60734_().getBeaconColorMultiplier(windowState, world, pos, beaconPos);
        }
        return super.getBeaconColorMultiplier(state, world, pos, beaconPos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new WindowInABlockTileEntity(pos, blockState);
    }
}

