/*
 * Decompiled with CFR 0.152.
 */
package mod.grimmauld.windowlogging;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mod.grimmauld.windowlogging.WindowInABlockTileEntity;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WindowInABlockModel
extends BakedModelWrapper<BakedModel> {
    private static final BlockRenderDispatcher DISPATCHER = Minecraft.m_91087_().m_91289_();

    public WindowInABlockModel(BakedModel original) {
        super(original);
    }

    private static void fightZfighting(BakedQuad q) {
        int[] data = q.m_111303_();
        Vec3i vec = q.m_111306_().m_122436_();
        int dirX = vec.m_123341_();
        int dirY = vec.m_123342_();
        int dirZ = vec.m_123343_();
        for (int i = 0; i < 4; ++i) {
            int j = data.length / 4 * i;
            float x = Float.intBitsToFloat(data[j]);
            float y = Float.intBitsToFloat(data[j + 1]);
            float z = Float.intBitsToFloat(data[j + 2]);
            double offset = q.m_111306_().m_122434_().m_6150_((double)x, (double)y, (double)z);
            if (!(offset < 9.765625E-4) && !(offset > 0.9990234375)) continue;
            data[j] = Float.floatToIntBits(x - 0.001953125f * (float)dirX);
            data[j + 1] = Float.floatToIntBits(y - 0.001953125f * (float)dirY);
            data[j + 2] = Float.floatToIntBits(z - 0.001953125f * (float)dirZ);
        }
    }

    private static boolean hasSolidSide(BlockState state, BlockGetter worldIn, BlockPos pos, Direction side) {
        return !state.m_60620_((Tag)BlockTags.f_13035_) && Block.m_49918_((VoxelShape)state.m_60816_(worldIn, pos), (Direction)side);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        WindowInABlockTileEntity windowInABlockTileEntity = (WindowInABlockTileEntity)((Object)data.getData(WindowInABlockTileEntity.WINDOWLOGGED_TE));
        if (windowInABlockTileEntity == null) {
            return quads;
        }
        BlockState partialState = windowInABlockTileEntity.getPartialBlock();
        BlockState windowState = windowInABlockTileEntity.getWindowBlock();
        BlockPos position = windowInABlockTileEntity.m_58899_();
        BlockEntity partialTE = windowInABlockTileEntity.getPartialBlockTileEntityIfPresent();
        Level world = windowInABlockTileEntity.m_58904_();
        if (world == null) {
            return quads;
        }
        RenderType renderType = MinecraftForgeClient.getRenderType();
        if (ItemBlockRenderTypes.canRenderInLayer((BlockState)partialState, (RenderType)renderType) && partialState.m_60799_() == RenderShape.MODEL) {
            BakedModel partialModel = DISPATCHER.m_110910_(partialState);
            quads.addAll(partialModel.getQuads(partialState, side, rand, partialModel.getModelData((BlockAndTintGetter)world, position, partialState, (IModelData)(partialTE == null ? EmptyModelData.INSTANCE : partialTE.getModelData()))));
        }
        if (ItemBlockRenderTypes.canRenderInLayer((BlockState)windowState, (RenderType)renderType)) {
            DISPATCHER.m_110910_(windowState).getQuads(windowState, side, rand, DISPATCHER.m_110910_(windowState).getModelData((BlockAndTintGetter)world, position, windowState, (IModelData)EmptyModelData.INSTANCE)).forEach(bakedQuad -> {
                if (!WindowInABlockModel.hasSolidSide(partialState, (BlockGetter)world, position, bakedQuad.m_111306_())) {
                    WindowInABlockModel.fightZfighting(bakedQuad);
                    quads.add((BakedQuad)bakedQuad);
                }
            });
        }
        return quads;
    }

    public TextureAtlasSprite getParticleIcon(IModelData data) {
        WindowInABlockTileEntity windowInABlockTileEntity = (WindowInABlockTileEntity)((Object)data.getData(WindowInABlockTileEntity.WINDOWLOGGED_TE));
        if (windowInABlockTileEntity == null) {
            return super.getParticleIcon(data);
        }
        BlockEntity partialTE = windowInABlockTileEntity.getPartialBlockTileEntityIfPresent();
        return DISPATCHER.m_110910_(windowInABlockTileEntity.getPartialBlock()).getParticleIcon(partialTE == null ? data : partialTE.getModelData());
    }

    public boolean m_7541_() {
        return MinecraftForgeClient.getRenderType() == RenderType.m_110451_();
    }
}

