/*
 * Decompiled with CFR 0.152.
 */
package mod.grimmauld.windowlogging;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mod.grimmauld.windowlogging.DeferredRegistries;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WindowInABlockTileEntity
extends BlockEntity {
    public static final ModelProperty<WindowInABlockTileEntity> WINDOWLOGGED_TE = new ModelProperty();
    private final IModelData modelData = new ModelDataMap.Builder().withInitial(WINDOWLOGGED_TE, (Object)this).build();
    private BlockState partialBlock = Blocks.f_50016_.m_49966_();
    private BlockState windowBlock = Blocks.f_50016_.m_49966_();
    private CompoundTag partialBlockTileData = new CompoundTag();
    private BlockEntity partialBlockTileEntity = null;

    public WindowInABlockTileEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)DeferredRegistries.WINDOW_IN_A_BLOCK_TILE_ENTITY.get(), pos, blockState);
        this.setPartialBlockTileData(new CompoundTag());
    }

    public CompoundTag getPartialBlockTileData() {
        return this.partialBlockTileData;
    }

    public void setPartialBlockTileData(CompoundTag partialBlockTileData) {
        this.partialBlockTileData = partialBlockTileData;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.partialBlock = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("PartialBlock"));
        this.windowBlock = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("WindowBlock"));
        this.setPartialBlockTileData(compound.m_128469_("PartialData"));
        this.requestModelDataUpdate();
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("PartialBlock", (Tag)NbtUtils.m_129202_((BlockState)this.getPartialBlock()));
        compound.m_128365_("WindowBlock", (Tag)NbtUtils.m_129202_((BlockState)this.getWindowBlock()));
        compound.m_128365_("PartialData", (Tag)this.partialBlockTileData);
    }

    public void updateWindowConnections() {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction side : Direction.values()) {
            BlockPos offsetPos = this.f_58858_.m_142300_(side);
            this.windowBlock = this.getWindowBlock().m_60728_(side, this.f_58857_.m_8055_(offsetPos), (LevelAccessor)this.f_58857_, this.f_58858_, offsetPos);
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 18);
        this.m_6596_();
    }

    @Nonnull
    public IModelData getModelData() {
        return this.modelData;
    }

    public BlockState getPartialBlock() {
        return this.partialBlock;
    }

    public void setPartialBlock(BlockState partialBlock) {
        this.partialBlock = partialBlock;
    }

    public BlockState getWindowBlock() {
        return this.windowBlock;
    }

    public void setWindowBlock(BlockState windowBlock) {
        this.windowBlock = windowBlock;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nullable
    public BlockEntity getPartialBlockTileEntityIfPresent() {
        EntityBlock entityBlock;
        block9: {
            block8: {
                BlockState blockState = this.getPartialBlock();
                if (!(blockState instanceof EntityBlock)) break block8;
                entityBlock = (EntityBlock)blockState;
                if (this.f_58857_ != null) break block9;
            }
            return null;
        }
        if (this.partialBlockTileEntity == null) {
            try {
                this.partialBlockTileEntity = entityBlock.m_142194_(this.f_58858_, this.partialBlock);
                if (this.partialBlockTileEntity != null) {
                    this.partialBlockTileEntity.f_58856_ = this.getPartialBlock();
                    this.partialBlockTileEntity.deserializeNBT(this.partialBlockTileData);
                    this.partialBlockTileEntity.m_142339_(this.f_58857_);
                }
            }
            catch (Exception e) {
                this.partialBlockTileEntity = null;
            }
        }
        return this.partialBlockTileEntity;
    }
}

