/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.integrations.jei;

import com.mojang.blaze3d.platform.InputConstants;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import thetadev.constructionwand.basics.ConfigClient;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.items.ModItems;

@JeiPlugin
public class ConstructionWandJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = new ResourceLocation("constructionwand", "constructionwand");
    private static final String baseKey = "constructionwand.description.";
    private static final String baseKeyItem = "item.constructionwand.";

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    private Component keyComboComponent(boolean shiftOpt, Component optkeyComponent) {
        String key = shiftOpt ? "sneak_opt" : "sneak";
        return new TranslatableComponent("constructionwand.description.key." + key, new Object[]{optkeyComponent}).m_130940_(ChatFormatting.BLUE);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        MutableComponent optkeyComponent = new TranslatableComponent(InputConstants.m_84827_((int)((Integer)ConfigClient.OPT_KEY.get()), (int)-1).m_84874_()).m_130940_(ChatFormatting.BLUE);
        Component wandModeComponent = this.keyComboComponent((Boolean)ConfigClient.SHIFTOPT_MODE.get(), (Component)optkeyComponent);
        Component wandGuiComponent = this.keyComboComponent((Boolean)ConfigClient.SHIFTOPT_GUI.get(), (Component)optkeyComponent);
        for (Item wand : ModItems.WANDS) {
            ConfigServer.WandProperties wandProperties = ConfigServer.getWandProperties(wand);
            String durabilityKey = wand == ModItems.WAND_INFINITY ? "unlimited" : "limited";
            TranslatableComponent durabilityComponent = new TranslatableComponent("constructionwand.description.durability." + durabilityKey, new Object[]{wandProperties.getDurability()});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)wand), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("constructionwand.description.wand", new Object[]{new TranslatableComponent(baseKeyItem + wand.getRegistryName().m_135815_()), wandProperties.getLimit(), durabilityComponent, optkeyComponent, wandModeComponent, wandGuiComponent})});
        }
        for (Item core : ModItems.CORES) {
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)core), VanillaTypes.ITEM, new Component[]{new TranslatableComponent(baseKey + core.getRegistryName().m_135815_()), new TranslatableComponent("constructionwand.description.core", new Object[]{wandModeComponent})});
        }
    }
}

