/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import java.math.BigDecimal;
import net.minecraft.world.item.enchantment.Enchantment;
import s_com.udojava.evalex.Expression;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.table.EnchantingStatManager;
import shadows.placebo.config.Configuration;

public class EnchantmentInfo {
    protected final Enchantment ench;
    protected final int maxLevel;
    protected final boolean treasure;
    protected final boolean discoverable;
    protected final boolean tradeable;
    protected final PowerFunc maxPower;
    protected final PowerFunc minPower;

    public EnchantmentInfo(Enchantment ench, int maxLevel, PowerFunc max, PowerFunc min, boolean treasure, boolean discoverable, boolean tradeable) {
        this.ench = ench;
        this.maxLevel = maxLevel;
        this.maxPower = max;
        this.minPower = min;
        this.treasure = treasure;
        this.discoverable = discoverable;
        this.tradeable = tradeable;
    }

    @Deprecated
    public EnchantmentInfo(Enchantment ench) {
        this(ench, ench.m_6586_(), EnchantmentInfo.defaultMax(ench), EnchantmentInfo.defaultMin(ench), ench.m_6591_(), ench.m_6592_(), ench.m_6594_());
    }

    public int getMaxLevel() {
        return Math.min(EnchModule.ENCH_HARD_CAPS.getOrDefault((Object)this.ench, Integer.MAX_VALUE), this.maxLevel);
    }

    public int getMinPower(int level) {
        return this.minPower.getPower(level);
    }

    public int getMaxPower(int level) {
        return this.maxPower.getPower(level);
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }

    public boolean isTreasure() {
        return this.treasure;
    }

    public boolean isTradeable() {
        return this.tradeable;
    }

    public static EnchantmentInfo load(Enchantment ench, Configuration cfg) {
        String category = ench.getRegistryName().toString();
        int max = cfg.getInt("Max Level", category, EnchModule.getDefaultMax(ench), 1, 127, "The max level of this enchantment - originally " + ench.m_6586_() + ".");
        String maxF = cfg.getString("Max Power Function", category, "", "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
        String minF = cfg.getString("Min Power Function", category, "", "A function to determine the min enchanting power.");
        PowerFunc maxPower = maxF.isEmpty() ? EnchantmentInfo.defaultMax(ench) : new ExpressionPowerFunc(maxF);
        PowerFunc minPower = minF.isEmpty() ? EnchantmentInfo.defaultMin(ench) : new ExpressionPowerFunc(minF);
        boolean treasure = cfg.getBoolean("Treasure", category, ench.m_6591_(), "If this enchantment is available via treasure (loot) sources. Ignored if not discoverable.");
        boolean discoverable = cfg.getBoolean("Discoverable", category, ench.m_6592_(), "If this enchantment is obtainable via loot and enchanting.");
        boolean tradeable = cfg.getBoolean("Tradeable", category, ench.m_6592_(), "If this enchantment is obtainable via villager trades.");
        EnchantmentInfo info = new EnchantmentInfo(ench, max, maxPower, minPower, treasure, discoverable, tradeable);
        String rarity = cfg.getString("Rarity", ench.getRegistryName().toString(), ench.m_44699_().name(), "The rarity of this enchantment.  Valid values are COMMON, UNCOMMON, RARE, and VERY_RARE.");
        try {
            Enchantment.Rarity r;
            ench.f_44674_ = r = Enchantment.Rarity.valueOf((String)rarity);
        }
        catch (Exception ex) {
            EnchModule.LOGGER.error("Failed to parse rarity for {}, as {} is not a valid rarity string.", (Object)ench.getRegistryName(), (Object)rarity);
        }
        return info;
    }

    private static PowerFunc defaultMax(Enchantment ench) {
        return level -> (int)(EnchantingStatManager.getAbsoluteMaxEterna() * 4.0f);
    }

    public static PowerFunc defaultMin(Enchantment ench) {
        return level -> {
            if (level > ench.m_6586_() && level > 1) {
                int diff = ench.m_6183_(ench.m_6586_()) - ench.m_6183_(ench.m_6586_() - 1);
                if (diff == 0) {
                    diff = 15;
                }
                return ench.m_6183_(level) + diff * (int)Math.pow(level - ench.m_6586_(), 1.6);
            }
            return ench.m_6183_(level);
        };
    }

    public static interface PowerFunc {
        public int getPower(int var1);
    }

    public static class ExpressionPowerFunc
    implements PowerFunc {
        Expression ex;

        public ExpressionPowerFunc(String func) {
            this.ex = new Expression(func);
        }

        @Override
        public int getPower(int level) {
            return this.ex.setVariable("x", new BigDecimal(level)).eval().intValue();
        }
    }
}

