/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.anvil;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.advancements.AdvancementTriggers;
import shadows.apotheosis.ench.anvil.AnvilTile;
import shadows.apotheosis.util.INBTSensitiveFallingBlock;

public class ApothAnvilBlock
extends AnvilBlock
implements INBTSensitiveFallingBlock,
EntityBlock {
    public ApothAnvilBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76281_, (MaterialColor)MaterialColor.f_76404_).m_60913_(5.0f, 1200.0f).m_60918_(SoundType.f_56749_));
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new AnvilTile(pPos, pState);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity te, ItemStack stack) {
        ItemStack anvil = new ItemStack((ItemLike)this);
        if (te instanceof AnvilTile) {
            Object ench = ((AnvilTile)te).getEnchantments();
            ench = ench.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            EnchantmentHelper.m_44865_(ench, (ItemStack)anvil);
        }
        ApothAnvilBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)anvil);
        super.m_6240_(world, player, pos, state, te, stack);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof AnvilTile) {
            ((AnvilTile)te).getEnchantments().putAll(EnchantmentHelper.m_44831_((ItemStack)stack));
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack anvil = new ItemStack((ItemLike)this);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof AnvilTile) {
            Object ench = ((AnvilTile)te).getEnchantments();
            ench = ench.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            EnchantmentHelper.m_44865_(ench, (ItemStack)anvil);
        }
        return anvil;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag flagIn) {
        if (!stack.m_41790_()) {
            tooltip.add((Component)new TranslatableComponent("info.apotheosis.anvil").m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!Apoth.Tiles.ANVIL.m_155262_(newState)) {
            world.m_46747_(pos);
        }
    }

    protected void m_6788_(FallingBlockEntity e) {
        super.m_6788_(e);
        BlockEntity te = e.f_19853_.m_7702_(new BlockPos(e.m_20182_()));
        e.f_31944_ = new CompoundTag();
        if (te instanceof AnvilTile) {
            e.f_31944_ = te.m_187480_();
        }
    }

    public void m_142216_(Level world, BlockPos pos, BlockState fallState, BlockState hitState, FallingBlockEntity anvil) {
        super.m_142216_(world, pos, fallState, hitState, anvil);
        List items = world.m_45976_(ItemEntity.class, new AABB(pos, pos.m_142082_(1, 1, 1)));
        if (anvil.f_31944_ == null) {
            return;
        }
        Map enchantments = EnchantmentHelper.m_44882_((ListTag)anvil.f_31944_.m_128437_("enchantments", 10));
        int oblit = enchantments.getOrDefault((Object)Apoth.Enchantments.OBLITERATION, 0);
        int split = enchantments.getOrDefault((Object)Apoth.Enchantments.SPLITTING, 0);
        int ub = enchantments.getOrDefault(Enchantments.f_44986_, 0);
        if (split > 0 || oblit > 0) {
            for (ItemEntity entity : items) {
                ItemStack stack = entity.m_32055_();
                if (stack.m_41720_() != Items.f_42690_) continue;
                ListTag enchants = EnchantedBookItem.m_41163_((ItemStack)stack);
                boolean handled = false;
                if (enchants.size() == 1 && oblit > 0) {
                    handled = this.handleObliteration(world, pos, entity, enchants);
                } else if (enchants.size() > 1 && split > 0) {
                    handled = this.handleSplitting(world, pos, entity, enchants);
                }
                if (!handled) continue;
                if (world.f_46441_.nextInt(1 + ub) != 0) break;
                BlockState dmg = ApothAnvilBlock.m_48824_((BlockState)fallState);
                if (dmg == null) {
                    world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    world.m_46796_(1029, pos, 0);
                    break;
                }
                world.m_46597_(pos, dmg);
                break;
            }
        }
    }

    protected boolean handleSplitting(Level world, BlockPos pos, ItemEntity entity, ListTag enchants) {
        entity.m_142687_(Entity.RemovalReason.DISCARDED);
        for (Tag nbt : enchants) {
            CompoundTag tag = (CompoundTag)nbt;
            int level = tag.m_128451_("lvl");
            Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(tag.m_128461_("id")));
            if (enchant == null) continue;
            ItemStack book = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchant, level));
            Block.m_49840_((Level)world, (BlockPos)pos.m_7494_(), (ItemStack)book);
        }
        world.m_6443_(ServerPlayer.class, new AABB(pos).m_82377_(5.0, 5.0, 5.0), EntitySelector.f_20408_).forEach(p -> AdvancementTriggers.SPLIT_BOOK.trigger(p.m_8960_()));
        return true;
    }

    protected boolean handleObliteration(Level world, BlockPos pos, ItemEntity entity, ListTag enchants) {
        CompoundTag nbt = enchants.m_128728_(0);
        int level = nbt.m_128451_("lvl") - 1;
        if (level <= 0) {
            return false;
        }
        Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(nbt.m_128461_("id")));
        if (enchant == null) {
            return false;
        }
        ItemStack book = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchant, level));
        entity.m_142687_(Entity.RemovalReason.DISCARDED);
        Block.m_49840_((Level)world, (BlockPos)pos.m_7494_(), (ItemStack)book);
        Block.m_49840_((Level)world, (BlockPos)pos.m_7494_(), (ItemStack)book.m_41777_());
        return true;
    }

    @Override
    public ItemStack toStack(BlockState state, CompoundTag tag) {
        ItemStack anvil = new ItemStack((ItemLike)this);
        Map<Enchantment, Integer> ench = EnchantmentHelper.m_44882_((ListTag)tag.m_128437_("enchantments", 10));
        ench = ench.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.m_44865_(ench, (ItemStack)anvil);
        return anvil;
    }
}

