/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion.compat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.Size2i;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ench.compat.EnchantingCategory;
import shadows.apotheosis.potion.PotionCharmItem;
import shadows.apotheosis.potion.PotionCharmRecipe;
import shadows.apotheosis.potion.PotionEnchantingRecipe;

@JeiPlugin
public class PotionJEIPlugin
implements IModPlugin {
    ICraftingGridHelper gridHelper;

    public void registerRecipes(IRecipeRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
        this.gridHelper = reg.getJeiHelpers().getGuiHelper().createCraftingGridHelper(1);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
        reg.getCraftingCategory().addCategoryExtension(PotionCharmRecipe.class, x$0 -> new PotionCharmRecipeWrapper((PotionCharmRecipe)((Object)x$0)));
        EnchantingCategory.registerExtension(PotionEnchantingRecipe.class, new PotionCharmEnchantingWrapper());
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
        reg.registerSubtypeInterpreter((Item)Apoth.Items.POTION_CHARM, (IIngredientSubtypeInterpreter)new PotionCharmSubtypes());
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("apotheosis", "potion");
    }

    private class PotionCharmEnchantingWrapper
    implements EnchantingCategory.Extension<PotionEnchantingRecipe> {
        private PotionCharmEnchantingWrapper() {
        }

        @Override
        public void setIngredients(PotionEnchantingRecipe recipe, IIngredients ing) {
            ing.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
            ing.setInputIngredients(Arrays.asList(recipe.getInput()));
        }

        @Override
        public void setRecipe(PotionEnchantingRecipe recipe, IRecipeLayout recipeLayout, IIngredients ingredients) {
            IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
            IFocus fcs = recipeLayout.getFocus(VanillaTypes.ITEM);
            ItemStack focus = fcs == null ? ItemStack.f_41583_ : (ItemStack)recipeLayout.getFocus(VanillaTypes.ITEM).getValue();
            Potion potion = PotionUtils.m_43579_((ItemStack)focus) == Potions.f_43598_ ? Potions.f_43614_ : PotionUtils.m_43579_((ItemStack)focus);
            ItemStack output = new ItemStack((ItemLike)Apoth.Items.POTION_CHARM);
            PotionUtils.m_43549_((ItemStack)output, (Potion)potion);
            ItemStack input = output.m_41777_();
            output.m_41784_().m_128379_("Unbreakable", true);
            stacks.set(1, output);
            stacks.set(0, input);
        }
    }

    private class PotionCharmSubtypes
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private PotionCharmSubtypes() {
        }

        public String apply(ItemStack stack, UidContext context) {
            if (context != UidContext.Recipe) {
                if (!PotionCharmItem.hasPotion(stack)) {
                    return "";
                }
                Potion p = PotionUtils.m_43579_((ItemStack)stack);
                MobEffectInstance contained = (MobEffectInstance)p.m_43488_().get(0);
                return contained.m_19544_().getRegistryName() + "@" + contained.m_19564_() + "@" + contained.m_19557_();
            }
            return "";
        }
    }

    private class PotionCharmRecipeWrapper
    implements ICustomCraftingCategoryExtension {
        private final PotionCharmRecipe recipe;

        PotionCharmRecipeWrapper(PotionCharmRecipe recipe) {
            this.recipe = recipe;
        }

        public void setIngredients(IIngredients ingredients) {
            ingredients.setInputIngredients((List)this.recipe.m_7527_());
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.m_8043_());
        }

        public ResourceLocation getRegistryName() {
            return this.recipe.m_6423_();
        }

        public Size2i getSize() {
            return new Size2i(3, 3);
        }

        public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            IFocus fcs = recipeLayout.getFocus(VanillaTypes.ITEM);
            ItemStack focus = fcs == null ? ItemStack.f_41583_ : (ItemStack)recipeLayout.getFocus(VanillaTypes.ITEM).getValue();
            Potion potion = PotionUtils.m_43579_((ItemStack)focus) == Potions.f_43598_ ? Potions.f_43614_ : PotionUtils.m_43579_((ItemStack)focus);
            List recipeInputs = ingredients.getInputs(VanillaTypes.ITEM);
            ArrayList clones = new ArrayList();
            recipeInputs.forEach(l -> {
                ArrayList cloneList = new ArrayList();
                l.stream().map(ItemStack::m_41777_).map(s -> s.m_41782_() && s.m_41783_().m_128441_("Potion") ? PotionUtils.m_43549_((ItemStack)s, (Potion)potion) : s).forEach(cloneList::add);
                clones.add(cloneList);
            });
            ItemStack output = new ItemStack((ItemLike)Apoth.Items.POTION_CHARM);
            PotionUtils.m_43549_((ItemStack)output, (Potion)potion);
            Size2i size = this.getSize();
            PotionJEIPlugin.this.gridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, clones, size.width, size.height);
            guiItemStacks.set(0, output);
        }
    }
}

