/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.spawner;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shadows.apotheosis.advancements.AdvancementTriggers;
import shadows.apotheosis.spawn.SpawnerModule;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.apotheosis.spawn.modifiers.SpawnerStats;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;
import shadows.placebo.util.IReplacementBlock;

public class ApothSpawnerBlock
extends SpawnerBlock
implements IReplacementBlock {
    protected StateDefinition<Block, BlockState> container;

    public ApothSpawnerBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.setRegistryName("minecraft", "spawner");
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack s = new ItemStack((ItemLike)this);
        BlockEntity te = world.m_7702_(pos);
        if (te != null) {
            s.m_41784_().m_128365_("BlockEntityTag", (Tag)te.m_187482_());
        }
        return s;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null) {
            te.m_142466_(stack.m_41698_("BlockEntityTag"));
        }
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ApothSpawnerTile(pPos, pState);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity te, ItemStack stack) {
        if (SpawnerModule.spawnerSilkLevel != -1 && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) >= SpawnerModule.spawnerSilkLevel) {
            ItemStack s = new ItemStack((ItemLike)this);
            if (te != null) {
                s.m_41784_().m_128365_("BlockEntityTag", (Tag)te.m_187482_());
            }
            ApothSpawnerBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)s);
            player.m_21205_().m_41622_(SpawnerModule.spawnerSilkDamage, (LivingEntity)player, pl -> pl.m_21166_(EquipmentSlot.MAINHAND));
            player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
            player.m_36399_(0.035f);
        } else {
            super.m_6240_(world, player, pos, state, te, stack);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ApothSpawnerTile tile;
        SpawnerModifier match;
        BlockEntity te = world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        ItemStack otherStack = player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        if (te instanceof ApothSpawnerTile && (match = SpawnerModifier.findMatch(tile = (ApothSpawnerTile)te, stack, otherStack)) != null && match.apply(tile)) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
                if (match.consumesOffhand()) {
                    otherStack.m_41774_(1);
                }
            }
            AdvancementTriggers.SPAWNER_MODIFIER.trigger((ServerPlayer)player, tile, match);
            world.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_() && stack.m_41783_().m_128425_("BlockEntityTag", 10)) {
            if (Screen.m_96638_()) {
                CompoundTag tag = stack.m_41783_().m_128469_("BlockEntityTag");
                if (tag.m_128441_("SpawnData")) {
                    String name = tag.m_128469_("SpawnData").m_128469_("entity").m_128461_("id");
                    String key = "entity." + name.replace(':', '.');
                    tooltip.add(ApothSpawnerBlock.concat(new TranslatableComponent("misc.apotheosis.entity"), I18n.m_118936_((String)key) ? I18n.m_118938_((String)key, (Object[])new Object[0]) : name));
                }
                if (tag.m_128441_("MinSpawnDelay")) {
                    tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.MIN_DELAY.name(), tag.m_128448_("MinSpawnDelay")));
                }
                if (tag.m_128441_("MaxSpawnDelay")) {
                    tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.MAX_DELAY.name(), tag.m_128448_("MaxSpawnDelay")));
                }
                if (tag.m_128441_("SpawnCount")) {
                    tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.SPAWN_COUNT.name(), tag.m_128448_("SpawnCount")));
                }
                if (tag.m_128441_("MaxNearbyEntities")) {
                    tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.MAX_NEARBY_ENTITIES.name(), tag.m_128448_("MaxNearbyEntities")));
                }
                if (tag.m_128441_("RequiredPlayerRange")) {
                    tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.REQ_PLAYER_RANGE.name(), tag.m_128448_("RequiredPlayerRange")));
                }
                if (tag.m_128441_("SpawnRange")) {
                    tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.SPAWN_RANGE.name(), tag.m_128448_("SpawnRange")));
                }
                if (tag.m_128471_("ignore_players")) {
                    tooltip.add((Component)SpawnerStats.IGNORE_PLAYERS.name().m_130940_(ChatFormatting.DARK_GREEN));
                }
                if (tag.m_128471_("ignore_conditions")) {
                    tooltip.add((Component)SpawnerStats.IGNORE_CONDITIONS.name().m_130940_(ChatFormatting.DARK_GREEN));
                }
                if (tag.m_128471_("redstone_control")) {
                    tooltip.add((Component)SpawnerStats.REDSTONE_CONTROL.name().m_130940_(ChatFormatting.DARK_GREEN));
                }
                if (tag.m_128471_("ignore_light")) {
                    tooltip.add((Component)SpawnerStats.IGNORE_LIGHT.name().m_130940_(ChatFormatting.DARK_GREEN));
                }
                if (tag.m_128471_("no_ai")) {
                    tooltip.add((Component)SpawnerStats.NO_AI.name().m_130940_(ChatFormatting.DARK_GREEN));
                }
            } else {
                tooltip.add((Component)new TranslatableComponent("misc.apotheosis.shift_stats").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public static Component concat(Object ... args) {
        return new TranslatableComponent("misc.apotheosis.value_concat", new Object[]{args[0], new TextComponent(args[1].toString()).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GREEN);
    }

    public Item m_5456_() {
        return Items.f_42007_;
    }

    public int getExpDrop(BlockState state, LevelReader world, BlockPos pos, int fortune, int silktouch) {
        return silktouch == 0 ? super.getExpDrop(state, world, pos, fortune, silktouch) : 0;
    }

    public void _setDefaultState(BlockState state) {
        this.m_49959_(state);
    }

    public void setStateContainer(StateDefinition<Block, BlockState> container) {
        this.container = container;
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        return this.container == null ? super.m_49965_() : this.container;
    }
}

