/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.village;

import java.io.File;
import java.util.Map;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.village.VillageModuleClient;
import shadows.apotheosis.village.fletching.ApothFletchingBlock;
import shadows.apotheosis.village.fletching.FletchingContainer;
import shadows.apotheosis.village.fletching.FletchingRecipe;
import shadows.apotheosis.village.fletching.arrows.BroadheadArrowEntity;
import shadows.apotheosis.village.fletching.arrows.BroadheadArrowItem;
import shadows.apotheosis.village.fletching.arrows.ExplosiveArrowEntity;
import shadows.apotheosis.village.fletching.arrows.ExplosiveArrowItem;
import shadows.apotheosis.village.fletching.arrows.IApothArrowItem;
import shadows.apotheosis.village.fletching.arrows.MiningArrowEntity;
import shadows.apotheosis.village.fletching.arrows.MiningArrowItem;
import shadows.apotheosis.village.fletching.arrows.ObsidianArrowEntity;
import shadows.apotheosis.village.fletching.arrows.ObsidianArrowItem;
import shadows.apotheosis.village.fletching.effects.BleedingEffect;
import shadows.apotheosis.village.wanderer.WandererReplacements;
import shadows.apotheosis.village.wanderer.WandererTradeManager;
import shadows.placebo.config.Configuration;
import shadows.placebo.util.PlaceboUtil;

public class VillageModule {
    public static final RecipeType<FletchingRecipe> FLETCHING = RecipeType.m_44119_((String)"apotheosis:fletching");
    public static final RecipeSerializer<FletchingRecipe> FLETCHING_SERIALIZER = new FletchingRecipe.Serializer();
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Village");
    public static Configuration config;

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        MinecraftForge.EVENT_BUS.addListener(WandererReplacements::replaceWandererArrays);
        MinecraftForge.EVENT_BUS.addListener(this::reloads);
        Map types = (Map)ObfuscationReflectionHelper.getPrivateValue(PoiType.class, null, (String)"f_27323_");
        types.put(Blocks.f_50622_.m_49966_(), PoiType.f_27338_);
        config = new Configuration(new File(Apotheosis.configDir, "village.cfg"));
        WandererReplacements.load(config);
        if (config.hasChanged()) {
            config.save();
        }
        e.enqueueWork(() -> {
            for (final Item i : ForgeRegistries.ITEMS) {
                if (!(i instanceof IApothArrowItem)) continue;
                DispenserBlock.m_52672_((ItemLike)i, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                    protected Projectile m_6895_(Level world, Position pos, ItemStack stack) {
                        return ((IApothArrowItem)i).fromDispenser(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public void setup(FMLClientSetupEvent e) {
        e.enqueueWork(VillageModuleClient::init);
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)FLETCHING_SERIALIZER.setRegistryName(FletchingRecipe.Serializer.NAME)));
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        PlaceboUtil.registerOverride((Block)new ApothFletchingBlock(), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ObsidianArrowItem().setRegistryName("obsidian_arrow"), (Item)new BroadheadArrowItem().setRegistryName("broadhead_arrow"), (Item)new ExplosiveArrowItem().setRegistryName("explosive_arrow"), (Item)new MiningArrowItem(() -> Items.f_42385_, MiningArrowEntity.Type.IRON).setRegistryName("iron_mining_arrow"), (Item)new MiningArrowItem(() -> Items.f_42390_, MiningArrowEntity.Type.DIAMOND).setRegistryName("diamond_mining_arrow")});
    }

    @SubscribeEvent
    public void entities(RegistryEvent.Register<EntityType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((EntityType)EntityType.Builder.m_20704_(ObsidianArrowEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).m_20699_(0.5f, 0.5f).setCustomClientFactory((se, w) -> new ObsidianArrowEntity((Level)w)).m_20712_("obsidian_arrow").setRegistryName("obsidian_arrow")));
        e.getRegistry().register((IForgeRegistryEntry)((EntityType)EntityType.Builder.m_20704_(BroadheadArrowEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).m_20699_(0.5f, 0.5f).setCustomClientFactory((se, w) -> new BroadheadArrowEntity((Level)w)).m_20712_("broadhead_arrow").setRegistryName("broadhead_arrow")));
        e.getRegistry().register((IForgeRegistryEntry)((EntityType)EntityType.Builder.m_20704_(ExplosiveArrowEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).m_20699_(0.5f, 0.5f).setCustomClientFactory((se, w) -> new ExplosiveArrowEntity((Level)w)).m_20712_("explosive_arrow").setRegistryName("explosive_arrow")));
        e.getRegistry().register((IForgeRegistryEntry)((EntityType)EntityType.Builder.m_20704_(MiningArrowEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).m_20699_(0.5f, 0.5f).setCustomClientFactory((se, w) -> new MiningArrowEntity((Level)w)).m_20712_("mining_arrow").setRegistryName("mining_arrow")));
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<MenuType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((MenuType)new MenuType(FletchingContainer::new).setRegistryName("fletching")));
    }

    @SubscribeEvent
    public void effects(RegistryEvent.Register<MobEffect> e) {
        e.getRegistry().register((IForgeRegistryEntry)((MobEffect)new BleedingEffect().setRegistryName("bleeding")));
    }

    public void reloads(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)WandererTradeManager.INSTANCE);
    }
}

