/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.multipiston;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.views.View;
import com.ldtteam.multipiston.AbstractWindowSkeleton;
import com.ldtteam.multipiston.TileEntityMultiPiston;
import com.ldtteam.multipiston.network.MultiPistonChangeMessage;
import com.ldtteam.multipiston.network.Network;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class WindowMultiPiston
extends AbstractWindowSkeleton {
    public static final String MULTI_BLOCK_RESOURCE_SUFFIX = ":gui/windowmultipiston.xml";
    public static final String INPUT_RANGE_NAME = "range";
    public static final String INPUT_SPEED = "speed";
    private static final String RES_STRING = "textures/gui/%s.png";
    private static final String GREEN_POS = "_green";
    private static final String RED_POS = "_red";
    public static final String BUTTON_CONFIRM = "confirm";
    public static final String BUTTON_CANCEL = "cancel";
    public static final String BUTTON_UP = "plus";
    public static final String BUTTON_DOWN = "minus";
    public static final String BUTTON_LEFT = "left";
    public static final String BUTTON_RIGHT = "right";
    public static final String BUTTON_FORWARD = "up";
    public static final String BUTTON_BACKWARD = "down";
    private final BlockPos pos;
    private Direction facing = Direction.UP;
    private Direction output = Direction.DOWN;
    private final TextField inputRange;
    private final TextField inputSpeed;

    public WindowMultiPiston(@Nullable BlockPos pos) {
        super("multipiston:gui/windowmultipiston.xml");
        this.pos = pos;
        this.inputRange = (TextField)this.findPaneOfTypeByID(INPUT_RANGE_NAME, TextField.class);
        this.inputSpeed = (TextField)this.findPaneOfTypeByID(INPUT_SPEED, TextField.class);
        this.init();
    }

    private void init() {
        this.registerButton(BUTTON_CONFIRM, this::confirmClicked);
        this.registerButton(BUTTON_CANCEL, this::cancelClicked);
        this.registerButton(BUTTON_LEFT, this::moveLeftClicked);
        this.registerButton(BUTTON_RIGHT, this::moveRightClicked);
        this.registerButton(BUTTON_UP, this::moveUpClicked);
        this.registerButton(BUTTON_DOWN, this::moveDownClicked);
        this.registerButton(BUTTON_BACKWARD, this::moveBackClicked);
        this.registerButton(BUTTON_FORWARD, this::moveForwardClicked);
    }

    public void onOpened() {
        BlockEntity block = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
        if (block instanceof TileEntityMultiPiston) {
            this.inputRange.setText(Integer.toString(((TileEntityMultiPiston)block).getRange()));
            this.inputSpeed.setText(Integer.toString(((TileEntityMultiPiston)block).getSpeed()));
            Direction dir = ((TileEntityMultiPiston)block).getDirection();
            Direction out = ((TileEntityMultiPiston)block).getOutput();
            this.enable(dir, dir, false);
            this.enable(out, out, true);
            return;
        }
        this.close();
    }

    private void enable(Direction oldFacing, Direction newFacing, boolean rightClick) {
        switch (oldFacing) {
            case DOWN: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_DOWN, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_DOWN)), false);
                break;
            }
            case NORTH: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_FORWARD, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_FORWARD)), false);
                break;
            }
            case SOUTH: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_BACKWARD, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_BACKWARD)), false);
                break;
            }
            case EAST: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_RIGHT, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_RIGHT)), false);
                break;
            }
            case WEST: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_LEFT, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_LEFT)), false);
                break;
            }
            default: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_UP, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_UP)), false);
            }
        }
        String color = rightClick ? RED_POS : GREEN_POS;
        switch (newFacing) {
            case DOWN: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_DOWN, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_DOWN + color)), false);
                break;
            }
            case NORTH: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_FORWARD, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_FORWARD + color)), false);
                break;
            }
            case SOUTH: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_BACKWARD, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_BACKWARD + color)), false);
                break;
            }
            case EAST: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_RIGHT, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_RIGHT + color)), false);
                break;
            }
            case WEST: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_LEFT, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_LEFT + color)), false);
                break;
            }
            default: {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_UP, ButtonImage.class)).setImage(new ResourceLocation("multipiston", String.format(RES_STRING, BUTTON_UP + color)), false);
            }
        }
        if (rightClick) {
            this.output = newFacing;
        } else {
            this.facing = newFacing;
        }
    }

    private void moveUpClicked() {
        this.enable(this.facing, Direction.UP, false);
    }

    private void moveDownClicked() {
        this.enable(this.facing, Direction.DOWN, false);
    }

    private void moveLeftClicked() {
        this.enable(this.facing, Direction.WEST, false);
    }

    private void moveForwardClicked() {
        this.enable(this.facing, Direction.NORTH, false);
    }

    private void moveBackClicked() {
        this.enable(this.facing, Direction.SOUTH, false);
    }

    private void moveRightClicked() {
        this.enable(this.facing, Direction.EAST, false);
    }

    private void confirmClicked() {
        int range = 3;
        int speed = 2;
        try {
            range = Integer.parseInt(this.inputRange.getText());
            speed = Integer.parseInt(this.inputSpeed.getText());
        }
        catch (NumberFormatException e) {
            Log.getLogger().warn("Unable to parse number for multipiston range or speed, considering default range/speed!", (Throwable)e);
        }
        BlockEntity block = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
        if (block instanceof TileEntityMultiPiston) {
            ((TileEntityMultiPiston)block).setSpeed(speed);
            ((TileEntityMultiPiston)block).setRange(range);
            ((TileEntityMultiPiston)block).setOutput(this.output);
            ((TileEntityMultiPiston)block).setDirection(this.facing);
        }
        Network.getNetwork().sendToServer(new MultiPistonChangeMessage(this.pos, this.facing, this.output, range, speed));
        this.close();
    }

    public boolean rightClick(double mx, double my) {
        Pane pane = this.findPaneForClick(mx, my);
        if (pane instanceof View) {
            pane = ((View)pane).findPaneForClick(mx, my);
        }
        if (pane instanceof Button && pane.isEnabled()) {
            this.enable(this.output, switch (pane.getID()) {
                case BUTTON_UP -> Direction.UP;
                case BUTTON_DOWN -> Direction.DOWN;
                case BUTTON_FORWARD -> Direction.NORTH;
                case BUTTON_BACKWARD -> Direction.SOUTH;
                case BUTTON_RIGHT -> Direction.EAST;
                case BUTTON_LEFT -> Direction.WEST;
                default -> Direction.UP;
            }, true);
            return true;
        }
        return false;
    }

    private void cancelClicked() {
        this.close();
    }
}

