/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.block.FarmlandMoistBlock;
import com.teammetallurgy.aquaculture.block.NeptunesBountyBlock;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.WormFarmBlock;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.item.BlockItemWithoutLevelRenderer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class AquaBlocks {
    public static final DeferredRegister<Block> BLOCK_DEFERRED = DeferredRegister.create(Block.class, (String)"aquaculture");
    public static final RegistryObject<Block> FARMLAND = AquaBlocks.register((Block)new FarmlandMoistBlock(), "farmland", null);
    public static final RegistryObject<Block> NEPTUNIUM_BLOCK = AquaBlocks.register(new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76421_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)), "neptunium_block");
    public static final RegistryObject<Block> NEPTUNES_BOUNTY = AquaBlocks.registerWithRenderer((Block)new NeptunesBountyBlock(), "neptunes_bounty", new Item.Properties());
    public static final RegistryObject<Block> TACKLE_BOX = AquaBlocks.registerWithRenderer((Block)new TackleBoxBlock(), "tackle_box", new Item.Properties());
    public static final RegistryObject<Block> WORM_FARM = AquaBlocks.register((Block)new WormFarmBlock(), "worm_farm");

    public static RegistryObject<Block> register(@Nonnull Block block, @Nonnull String name) {
        return AquaBlocks.register(block, name, new Item.Properties());
    }

    public static RegistryObject<Block> register(@Nonnull Block block, @Nonnull String name, @Nullable Item.Properties properties) {
        AquaItems.register(() -> new BlockItem(block, properties == null ? new Item.Properties() : properties.m_41491_(Aquaculture.GROUP)), name);
        return AquaBlocks.registerBaseBlock(() -> block, name);
    }

    public static RegistryObject<Block> registerWithRenderer(@Nonnull Block block, @Nonnull String name, @Nullable Item.Properties properties) {
        AquaItems.register(() -> new BlockItemWithoutLevelRenderer(block, properties == null ? new Item.Properties() : properties.m_41491_(Aquaculture.GROUP)), name);
        return AquaBlocks.registerBaseBlock(() -> block, name);
    }

    public static RegistryObject<Block> registerBaseBlock(@Nonnull Supplier<Block> initializer, @Nonnull String name) {
        return BLOCK_DEFERRED.register(name, initializer);
    }
}

