/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSObjects;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.bindings.BlockWrapper;
import dev.latvian.mods.kubejs.bindings.IngredientWrapper;
import dev.latvian.mods.kubejs.bindings.ItemWrapper;
import dev.latvian.mods.kubejs.bindings.RarityWrapper;
import dev.latvian.mods.kubejs.bindings.TextWrapper;
import dev.latvian.mods.kubejs.bindings.UtilsWrapper;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockRegistryEventJS;
import dev.latvian.mods.kubejs.block.DetectorInstance;
import dev.latvian.mods.kubejs.block.MaterialJS;
import dev.latvian.mods.kubejs.block.MaterialListJS;
import dev.latvian.mods.kubejs.block.custom.BasicBlockType;
import dev.latvian.mods.kubejs.block.custom.BlockType;
import dev.latvian.mods.kubejs.block.custom.BlockTypes;
import dev.latvian.mods.kubejs.block.custom.ShapedBlockType;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.client.painter.screen.AtlasTextureObject;
import dev.latvian.mods.kubejs.client.painter.screen.GradientObject;
import dev.latvian.mods.kubejs.client.painter.screen.RectangleObject;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenGroup;
import dev.latvian.mods.kubejs.client.painter.screen.TextObject;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.event.DataEvent;
import dev.latvian.mods.kubejs.event.EventsJS;
import dev.latvian.mods.kubejs.event.IEventHandler;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.fluid.FluidRegistryEventJS;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemRegistryEventJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.custom.ItemArmorTierEventJS;
import dev.latvian.mods.kubejs.item.custom.ItemToolTierEventJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.item.type.ArmorItemType;
import dev.latvian.mods.kubejs.item.type.BasicItemType;
import dev.latvian.mods.kubejs.item.type.ItemType;
import dev.latvian.mods.kubejs.item.type.ItemTypes;
import dev.latvian.mods.kubejs.item.type.ToolItemType;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.gen.filter.biome.BiomeFilter;
import dev.latvian.mods.kubejs.level.gen.filter.mob.MobFilter;
import dev.latvian.mods.kubejs.loot.LootBuilder;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionFilter;
import dev.latvian.mods.kubejs.recipe.minecraft.CookingRecipeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.SmithingRecipeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.StonecuttingRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ArsNouveauEnchantingApparatusRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ArsNouveauEnchantmentRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ArsNouveauGlyphPressRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.BotaniaRunicAltarRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.BotanyPotsCropRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.IDSqueezerRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.MATagRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.MalumSpiritFocusingRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ShapedArtisanRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ShapelessArtisanRecipeJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.PlatformWrapper;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.text.Text;
import dev.latvian.mods.kubejs.util.BuilderBase;
import dev.latvian.mods.kubejs.util.ClassFilter;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.NBTIOWrapper;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.util.NBTWrapper;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.wrapper.AABBWrapper;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import dev.latvian.mods.rhino.mod.wrapper.DirectionWrapper;
import dev.latvian.mods.rhino.mod.wrapper.UUIDWrapper;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BuiltinKubeJSPlugin
extends KubeJSPlugin {
    public static final HashMap<String, Object> GLOBAL = new HashMap();

    @Override
    public void init() {
        BlockTypes.register(BasicBlockType.INSTANCE);
        BlockTypes.register(ShapedBlockType.SLAB);
        BlockTypes.register(ShapedBlockType.STAIRS);
        BlockTypes.register(ShapedBlockType.FENCE);
        BlockTypes.register(ShapedBlockType.FENCE_GATE);
        BlockTypes.register(ShapedBlockType.WALL);
        BlockTypes.register(ShapedBlockType.WOODEN_PRESSURE_PLATE);
        BlockTypes.register(ShapedBlockType.STONE_PRESSURE_PLATE);
        BlockTypes.register(ShapedBlockType.WOODEN_BUTTON);
        BlockTypes.register(ShapedBlockType.STONE_BUTTON);
        ItemTypes.register(BasicItemType.INSTANCE);
        ItemTypes.register(ToolItemType.SWORD);
        ItemTypes.register(ToolItemType.PICKAXE);
        ItemTypes.register(ToolItemType.AXE);
        ItemTypes.register(ToolItemType.SHOVEL);
        ItemTypes.register(ToolItemType.HOE);
        ItemTypes.register(ArmorItemType.HELMET);
        ItemTypes.register(ArmorItemType.CHESTPLATE);
        ItemTypes.register(ArmorItemType.LEGGINGS);
        ItemTypes.register(ArmorItemType.BOOTS);
    }

    @Override
    public void initStartup() {
        new ItemToolTierEventJS().post("item.registry.tool_tiers");
        new ItemArmorTierEventJS().post("item.registry.armor_tiers");
        new BlockRegistryEventJS().post("block.registry");
        new ItemRegistryEventJS().post("item.registry");
        new FluidRegistryEventJS().post("fluid.registry");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        Painter.INSTANCE.registerObject("screen_group", ScreenGroup::new);
        Painter.INSTANCE.registerObject("rectangle", RectangleObject::new);
        Painter.INSTANCE.registerObject("text", TextObject::new);
        Painter.INSTANCE.registerObject("atlas_texture", AtlasTextureObject::new);
        Painter.INSTANCE.registerObject("gradient", GradientObject::new);
    }

    @Override
    public void addClasses(ScriptType type, ClassFilter filter) {
        filter.allow("java.lang.Number");
        filter.allow("java.lang.String");
        filter.allow("java.lang.Character");
        filter.allow("java.lang.Byte");
        filter.allow("java.lang.Short");
        filter.allow("java.lang.Integer");
        filter.allow("java.lang.Long");
        filter.allow("java.lang.Float");
        filter.allow("java.lang.Double");
        filter.allow("java.lang.Boolean");
        filter.allow("java.lang.Runnable");
        filter.allow("java.lang.Iterable");
        filter.allow("java.lang.Comparable");
        filter.allow("java.lang.CharSequence");
        filter.allow("java.math.BigInteger");
        filter.allow("java.math.BigDecimal");
        filter.deny("java.io");
        filter.allow("java.io.Closeable");
        filter.allow("java.io.Serializable");
        filter.deny("java.nio");
        filter.allow("java.nio.ByteOrder");
        filter.allow("java.util");
        filter.deny("java.util.jar");
        filter.deny("java.util.zip");
        filter.allow("it.unimi.dsi.fastutil");
        filter.allow("dev.latvian.mods.kubejs");
        filter.deny("dev.latvian.mods.kubejs.script");
        filter.deny("dev.latvian.mods.kubejs.mixin");
        filter.deny(KubeJSPlugin.class);
        filter.deny(KubeJSPlugins.class);
        filter.allow("net.minecraft");
        filter.allow("com.mojang.authlib.GameProfile");
        filter.allow("com.mojang.util.UUIDTypeAdapter");
        filter.allow("com.mojang.brigadier");
        filter.allow("dev.architectury");
        filter.deny("java.net");
        filter.deny("sun");
        filter.deny("com.sun");
        filter.deny("io.netty");
        filter.deny("org.objectweb.asm");
        filter.deny("org.spongepowered.asm");
        filter.deny("org.openjdk.nashorn");
        filter.deny("jdk.nashorn");
        filter.allow("mezz.jei");
    }

    @Override
    public void addBindings(BindingsEvent event) {
        event.add("global", GLOBAL);
        if (event.type == ScriptType.SERVER) {
            ServerSettings.instance = new ServerSettings();
            event.add("settings", ServerSettings.instance);
        }
        event.add("Platform", PlatformWrapper.class);
        event.add("console", event.type.console);
        event.addFunction("onEvent", args -> BuiltinKubeJSPlugin.onEvent(event, args), null, IEventHandler.class);
        event.addFunction("postEvent", args -> BuiltinKubeJSPlugin.postEvent(event, args), String.class, Object.class, Boolean.class);
        event.addFunction("java", args -> event.manager.loadJavaClass(event.scope, args), new Class[]{null});
        event.add("JavaMath", Math.class);
        event.add("ResourceLocation", ResourceLocation.class);
        event.add("Utils", UtilsWrapper.class);
        event.add("Text", TextWrapper.class);
        event.add("UUID", UUIDWrapper.class);
        event.add("JsonIO", JsonIO.class);
        event.add("Block", BlockWrapper.class);
        event.add("Item", ItemWrapper.class);
        event.add("Ingredient", IngredientWrapper.class);
        event.add("NBT", NBTWrapper.class);
        event.add("NBTIO", NBTIOWrapper.class);
        event.add("Direction", DirectionWrapper.class);
        event.add("Facing", DirectionWrapper.class);
        event.add("AABB", AABBWrapper.class);
        event.add("Fluid", FluidWrapper.class);
        event.add("SECOND", 1000L);
        event.add("MINUTE", 60000L);
        event.add("HOUR", 3600000L);
        event.add("Color", ColorWrapper.class);
        event.add("BlockStatePredicate", BlockStatePredicate.class);
        event.add("EquipmentSlot", EquipmentSlot.class);
        event.add("SLOT_MAINHAND", EquipmentSlot.MAINHAND);
        event.add("SLOT_OFFHAND", EquipmentSlot.OFFHAND);
        event.add("SLOT_FEET", EquipmentSlot.FEET);
        event.add("SLOT_LEGS", EquipmentSlot.LEGS);
        event.add("SLOT_CHEST", EquipmentSlot.CHEST);
        event.add("SLOT_HEAD", EquipmentSlot.HEAD);
        event.add("Rarity", RarityWrapper.class);
        event.add("RARITY_COMMON", RarityWrapper.COMMON);
        event.add("RARITY_UNCOMMON", RarityWrapper.UNCOMMON);
        event.add("RARITY_RARE", RarityWrapper.RARE);
        event.add("RARITY_EPIC", RarityWrapper.EPIC);
        event.add("AIR_ITEM", Items.f_41852_);
        event.add("AIR_BLOCK", Blocks.f_50016_);
        event.add("Hand", InteractionHand.class);
        event.add("MAIN_HAND", InteractionHand.MAIN_HAND);
        event.add("OFF_HAND", InteractionHand.OFF_HAND);
        event.add("DecorationGenerationStep", GenerationStep.Decoration.class);
        event.add("CarvingGenerationStep", GenerationStep.Carving.class);
        event.add("Vec3", Vec3.class);
        event.add("Vec3d", Vec3.class);
        event.add("Vec3i", Vec3i.class);
        event.add("BlockPos", BlockPos.class);
        KubeJS.PROXY.clientBindings(event);
    }

    private static Object onEvent(BindingsEvent event, Object[] args) {
        for (Object o : ListJS.orSelf(args[0])) {
            event.type.manager.get().events.listen(String.valueOf(o), (IEventHandler)args[1]);
        }
        return null;
    }

    private static Object postEvent(BindingsEvent event, Object[] args) {
        String id = String.valueOf(args[0]);
        Object data = args.length >= 2 ? args[1] : null;
        boolean cancellable = args.length >= 3 && Boolean.TRUE.equals(args[2]);
        EventsJS events = event.type.manager.get().events;
        return events.postToHandlers(id, events.handlers(id), new DataEvent(cancellable, data));
    }

    @Override
    public void addTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        typeWrappers.register(String.class, String::valueOf);
        typeWrappers.register(CharSequence.class, String::valueOf);
        typeWrappers.register(UUID.class, UUIDWrapper::fromString);
        typeWrappers.register(Pattern.class, UtilsJS::parseRegex);
        typeWrappers.register(JsonObject.class, MapJS::json);
        typeWrappers.register(JsonArray.class, ListJS::json);
        typeWrappers.register(JsonElement.class, JsonIO::of);
        typeWrappers.register(JsonPrimitive.class, JsonIO::primitiveOf);
        typeWrappers.register(Path.class, UtilsJS::getPath);
        typeWrappers.register(File.class, UtilsJS::getFileFromPath);
        typeWrappers.register(ResourceLocation.class, UtilsJS::getMCID);
        typeWrappers.register(ItemStack.class, o -> ItemStackJS.of(o).getItemStack());
        typeWrappers.register(CompoundTag.class, MapJS::isNbt, MapJS::nbt);
        typeWrappers.register(CollectionTag.class, ListJS::nbt);
        typeWrappers.register(ListTag.class, o -> (ListTag)ListJS.nbt(o));
        typeWrappers.register(Component.class, Text::componentOf);
        typeWrappers.register(MutableComponent.class, o -> new TextComponent("").m_7220_(Text.componentOf(o)));
        typeWrappers.register(BlockPos.class, o -> {
            List list;
            if (o instanceof BlockPos) {
                BlockPos pos = (BlockPos)o;
                return pos;
            }
            if (o instanceof List && (list = (List)o).size() >= 3) {
                return new BlockPos(UtilsJS.parseInt(list.get(0), 0), UtilsJS.parseInt(list.get(1), 0), UtilsJS.parseInt(list.get(2), 0));
            }
            if (o instanceof BlockContainerJS) {
                BlockContainerJS block = (BlockContainerJS)o;
                return block.getPos();
            }
            return BlockPos.f_121853_;
        });
        typeWrappers.register(Vec3.class, o -> {
            List list;
            if (o instanceof Vec3) {
                Vec3 vec = (Vec3)o;
                return vec;
            }
            if (o instanceof EntityJS) {
                EntityJS entity = (EntityJS)o;
                return entity.minecraftEntity.m_20182_();
            }
            if (o instanceof List && (list = (List)o).size() >= 3) {
                return new Vec3(UtilsJS.parseDouble(list.get(0), 0.0), UtilsJS.parseDouble(list.get(1), 0.0), UtilsJS.parseDouble(list.get(2), 0.0));
            }
            if (o instanceof BlockPos) {
                BlockPos pos = (BlockPos)o;
                return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            }
            if (o instanceof BlockContainerJS) {
                BlockContainerJS block = (BlockContainerJS)o;
                return new Vec3((double)block.getPos().m_123341_() + 0.5, (double)block.getPos().m_123342_() + 0.5, (double)block.getPos().m_123343_() + 0.5);
            }
            return Vec3.f_82478_;
        });
        typeWrappers.register(Item.class, ItemStackJS::getRawItem);
        typeWrappers.register(GenerationStep.Decoration.class, o -> {
            try {
                return GenerationStep.Decoration.valueOf((String)o.toString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        });
        typeWrappers.register(MobCategory.class, o -> o == null ? null : MobCategory.m_21605_((String)o.toString()));
        typeWrappers.register(TextColor.class, o -> {
            if (o instanceof Number) {
                Number number = (Number)o;
                return TextColor.m_131266_((int)(number.intValue() & 0xFFFFFF));
            }
            if (o instanceof ChatFormatting) {
                ChatFormatting legacyColor = (ChatFormatting)o;
                return TextColor.m_131270_((ChatFormatting)legacyColor);
            }
            return TextColor.m_131268_((String)o.toString());
        });
        typeWrappers.register(AABB.class, AABBWrapper::wrap);
        typeWrappers.register(Direction.class, o -> {
            Direction dir;
            return o instanceof Direction ? (dir = (Direction)o) : (Direction)DirectionWrapper.ALL.get(o.toString().toLowerCase());
        });
        typeWrappers.register(IntProvider.class, UtilsJS::intProviderOf);
        typeWrappers.register(NumberProvider.class, UtilsJS::numberProviderOf);
        typeWrappers.register(LootContext.EntityTarget.class, o -> o == null ? null : LootContext.EntityTarget.m_79006_((String)o.toString().toLowerCase()));
        typeWrappers.register(CopyNameFunction.NameSource.class, o -> o == null ? null : CopyNameFunction.NameSource.m_80208_((String)o.toString().toLowerCase()));
        typeWrappers.register(MapJS.class, MapJS::of);
        typeWrappers.register(ListJS.class, ListJS::of);
        typeWrappers.register(ItemStackJS.class, ItemStackJS::of);
        typeWrappers.register(IngredientJS.class, IngredientJS::of);
        typeWrappers.register(IngredientStackJS.class, o -> IngredientJS.of(o).asIngredientStack());
        typeWrappers.register(Text.class, Text::of);
        typeWrappers.register(BlockStatePredicate.class, BlockStatePredicate::of);
        typeWrappers.register(RuleTest.class, BlockStatePredicate::ruleTestOf);
        typeWrappers.register(BiomeFilter.class, BiomeFilter::of);
        typeWrappers.register(MobFilter.class, MobFilter::of);
        typeWrappers.register(FluidStackJS.class, FluidStackJS::of);
        typeWrappers.register(RecipeFilter.class, RecipeFilter::of);
        typeWrappers.register(MaterialJS.class, MaterialListJS.INSTANCE::of);
        typeWrappers.register(ItemType.class, ItemTypes::get);
        typeWrappers.register(BlockType.class, BlockTypes::get);
        typeWrappers.register(Color.class, ColorWrapper::of);
        typeWrappers.register(IngredientActionFilter.class, IngredientActionFilter::filterOf);
        KubeJS.PROXY.clientTypeWrappers(typeWrappers);
    }

    @Override
    public void addRecipes(RegisterRecipeHandlersEvent event) {
        event.registerShaped(new ResourceLocation("kubejs:shaped"));
        event.registerShapeless(new ResourceLocation("kubejs:shapeless"));
        event.registerShaped(new ResourceLocation("minecraft:crafting_shaped"));
        event.registerShapeless(new ResourceLocation("minecraft:crafting_shapeless"));
        event.register(new ResourceLocation("minecraft:stonecutting"), StonecuttingRecipeJS::new);
        event.register(new ResourceLocation("minecraft:smelting"), CookingRecipeJS::new);
        event.register(new ResourceLocation("minecraft:blasting"), CookingRecipeJS::new);
        event.register(new ResourceLocation("minecraft:smoking"), CookingRecipeJS::new);
        event.register(new ResourceLocation("minecraft:campfire_cooking"), CookingRecipeJS::new);
        event.register(new ResourceLocation("minecraft:smithing"), SmithingRecipeJS::new);
        if (Platform.isModLoaded((String)"cucumber")) {
            event.registerShaped(new ResourceLocation("cucumber:shaped_no_mirror"));
        }
        if (Platform.isModLoaded((String)"mysticalagriculture")) {
            event.register(new ResourceLocation("mysticalagriculture:tag"), MATagRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"botanypots")) {
            event.register(new ResourceLocation("botanypots:crop"), BotanyPotsCropRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"extendedcrafting")) {
            event.registerShaped(new ResourceLocation("extendedcrafting:shaped_table"));
            event.registerShapeless(new ResourceLocation("extendedcrafting:shapeless_table"));
        }
        if (Platform.isModLoaded((String)"dankstorage")) {
            event.registerShaped(new ResourceLocation("dankstorage:upgrade"));
        }
        if (Platform.isModLoaded((String)"artisanworktables")) {
            String[] types;
            for (String t : types = new String[]{"basic", "blacksmith", "carpenter", "chef", "chemist", "designer", "engineer", "farmer", "jeweler", "mage", "mason", "potter", "scribe", "tailor", "tanner"}) {
                event.register(new ResourceLocation("artisanworktables:" + t + "_shaped"), ShapedArtisanRecipeJS::new);
                event.register(new ResourceLocation("artisanworktables:" + t + "_shapeless"), ShapelessArtisanRecipeJS::new);
            }
        }
        if (Platform.isModLoaded((String)"botania")) {
            event.register(new ResourceLocation("botania:runic_altar"), BotaniaRunicAltarRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"integrateddynamics") && !Platform.isModLoaded((String)"kubejs_integrated_dynamics")) {
            event.register(new ResourceLocation("integrateddynamics:squeezer"), IDSqueezerRecipeJS::new);
            event.register(new ResourceLocation("integrateddynamics:mechanical_squeezer"), IDSqueezerRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"ars_nouveau")) {
            event.register(new ResourceLocation("ars_nouveau:enchanting_apparatus"), ArsNouveauEnchantingApparatusRecipeJS::new);
            event.register(new ResourceLocation("ars_nouveau:enchantment"), ArsNouveauEnchantmentRecipeJS::new);
            event.register(new ResourceLocation("ars_nouveau:glyph_recipe"), ArsNouveauGlyphPressRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"malum")) {
            event.register(new ResourceLocation("malum:spirit_focusing"), MalumSpiritFocusingRecipeJS::new);
        }
    }

    @Override
    public void generateDataJsons(DataJsonGenerator generator) {
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            if (blockBuilder.lootTable != null) {
                LootBuilder lootBuilder = new LootBuilder(null);
                lootBuilder.type = "minecraft:block";
                blockBuilder.lootTable.accept(lootBuilder);
                generator.json(blockBuilder.newID("loot_tables/blocks/", ""), (JsonElement)lootBuilder.toJson());
            }
            blockBuilder.type.generateData(blockBuilder, generator);
        }
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            itemBuilder.type.generateData(itemBuilder, generator);
        }
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            generator.blockState(new ResourceLocation("kubejs", "detector_" + detectorInstance.id), bs -> {
                bs.variant("powered=false", "kubejs:block/detector");
                bs.variant("powered=true", "kubejs:block/detector_on");
            });
            generator.itemModel(new ResourceLocation("kubejs", "detector_" + detectorInstance.id), m -> m.parent("kubejs:block/detector"));
        }
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            blockBuilder.type.generateAssets(blockBuilder, generator);
        }
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            itemBuilder.type.generateAssets(itemBuilder, generator);
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            generator.json(fluidBuilder.newID("blockstates/", ""), (JsonElement)fluidBuilder.getBlockstateJson());
            generator.json(fluidBuilder.newID("models/block/", ""), (JsonElement)fluidBuilder.getBlockModelJson());
            JsonObject bucketModel = new JsonObject();
            bucketModel.addProperty("parent", "kubejs:item/generated_bucket");
            generator.json(fluidBuilder.newID("models/item/", "_bucket"), (JsonElement)bucketModel);
        }
    }

    @Override
    public void generateLang(Map<String, String> lang) {
        lang.put("itemGroup.kubejs.kubejs", "KubeJS");
        lang.put("item.kubejs.dummy_fluid_item", "Dummy Fluid Item");
        for (BuilderBase builderBase : KubeJSObjects.ALL) {
            if (builderBase.displayName.isEmpty()) continue;
            lang.put(builderBase.translationKey, builderBase.displayName);
        }
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            lang.put("block.kubejs.detector_" + detectorInstance.id, "KubeJS Detector [" + detectorInstance.id + "]");
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            if (fluidBuilder.displayName.isEmpty()) continue;
            lang.put(fluidBuilder.bucketItem.m_5524_(), fluidBuilder.displayName + " Bucket");
        }
    }
}

