/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.utils.value.IntValue;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJSObjects;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.block.BlockBreakEventJS;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockLeftClickEventJS;
import dev.latvian.mods.kubejs.block.BlockPlaceEventJS;
import dev.latvian.mods.kubejs.block.BlockRightClickEventJS;
import dev.latvian.mods.kubejs.block.DetectorBlock;
import dev.latvian.mods.kubejs.block.DetectorInstance;
import dev.latvian.mods.kubejs.block.forge.KubeJSBlockEventHandlerImpl;
import dev.latvian.mods.kubejs.core.BlockKJS;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public class KubeJSBlockEventHandler {
    public static void init() {
        if (!CommonProperties.get().serverOnly) {
            KubeJSBlockEventHandler.registry();
        }
        InteractionEvent.RIGHT_CLICK_BLOCK.register(KubeJSBlockEventHandler::rightClick);
        InteractionEvent.LEFT_CLICK_BLOCK.register(KubeJSBlockEventHandler::leftClick);
        BlockEvent.BREAK.register(KubeJSBlockEventHandler::blockBreak);
        BlockEvent.PLACE.register(KubeJSBlockEventHandler::blockPlace);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static LiquidBlock buildFluidBlock(FluidBuilder builder, BlockBehaviour.Properties properties) {
        void var1_1;
        return KubeJSBlockEventHandlerImpl.buildFluidBlock(builder, (BlockBehaviour.Properties)var1_1);
    }

    private static void registry() {
        Iterator<Object> iterator = KubeJSObjects.BLOCKS.values().iterator();
        while (iterator.hasNext()) {
            BlockBuilder blockBuilder;
            BlockBuilder.current = blockBuilder = iterator.next();
            blockBuilder.block = blockBuilder.type.createBlock(blockBuilder);
            Block block = blockBuilder.block;
            if (block instanceof BlockKJS) {
                BlockKJS blockKJS = (BlockKJS)block;
                blockKJS.setBlockBuilderKJS(blockBuilder);
            }
            KubeJSRegistries.blocks().register(blockBuilder.id, () -> builder.block);
        }
        BlockBuilder.current = null;
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            fluidBuilder.block = KubeJSBlockEventHandler.buildFluidBlock(fluidBuilder, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_());
            KubeJSRegistries.blocks().register(fluidBuilder.id, () -> builder.block);
        }
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            detectorInstance.block = KubeJSRegistries.blocks().register(new ResourceLocation("kubejs", "detector_" + detectorInstance.id), () -> new DetectorBlock(detector.id));
        }
    }

    private static EventResult rightClick(Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        if (player != null && player.f_19853_ != null && !player.m_36335_().m_41519_(player.m_21120_(hand).m_41720_()) && new BlockRightClickEventJS(player, hand, pos, direction).post("block.right_click")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult leftClick(Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        if (player != null && player.f_19853_ != null && new BlockLeftClickEventJS(player, hand, pos, direction).post("block.left_click")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult blockBreak(Level level, BlockPos pos, BlockState state, ServerPlayer player, @Nullable IntValue xp) {
        if (player != null && player.f_19853_ != null && new BlockBreakEventJS(player, level, pos, state, xp).post("block.break")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult blockPlace(Level level, BlockPos pos, BlockState state, @Nullable Entity placer) {
        if (level != null && (placer == null || placer.f_19853_ != null) && new BlockPlaceEventJS(placer, level, pos, state).post("block.place")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

