/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.custom.BlockType;
import dev.latvian.mods.kubejs.block.custom.CustomBlockJS;
import dev.latvian.mods.kubejs.block.custom.FenceBlockJS;
import dev.latvian.mods.kubejs.block.custom.FenceGateBlockJS;
import dev.latvian.mods.kubejs.block.custom.SlabBlockJS;
import dev.latvian.mods.kubejs.block.custom.StairBlockJS;
import dev.latvian.mods.kubejs.block.custom.StoneButtonBlockJS;
import dev.latvian.mods.kubejs.block.custom.StonePressurePlateBlockJS;
import dev.latvian.mods.kubejs.block.custom.WallBlockJS;
import dev.latvian.mods.kubejs.block.custom.WoodenButtonBlockJS;
import dev.latvian.mods.kubejs.block.custom.WoodenPressurePlateBlockJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ShapedBlockType
extends BlockType {
    public static final ShapedBlockType SLAB = new ShapedBlockType("slab", SlabBlockJS::new, "_slab");
    public static final ShapedBlockType STAIRS = new ShapedBlockType("stairs", StairBlockJS::new, "_stairs");
    public static final ShapedBlockType FENCE = new ShapedBlockType("fence", FenceBlockJS::new, "_fence");
    public static final ShapedBlockType FENCE_GATE = new ShapedBlockType("fence_gate", FenceGateBlockJS::new, "_fence_gate");
    public static final ShapedBlockType WALL = new ShapedBlockType("wall", WallBlockJS::new, "_wall");
    public static final ShapedBlockType WOODEN_PRESSURE_PLATE = new ShapedBlockType("wooden_pressure_plate", WoodenPressurePlateBlockJS::new, "_wooden_pressure_plate", "_pressure_plate");
    public static final ShapedBlockType STONE_PRESSURE_PLATE = new ShapedBlockType("stone_pressure_plate", StonePressurePlateBlockJS::new, "_stone_pressure_plate", "_pressure_plate");
    public static final ShapedBlockType WOODEN_BUTTON = new ShapedBlockType("wooden_button", WoodenButtonBlockJS::new, "_wooden_button", "_button");
    public static final ShapedBlockType STONE_BUTTON = new ShapedBlockType("stone_button", StoneButtonBlockJS::new, "_stone_button", "_button");
    private final Function<BlockBehaviour.Properties, Block> factory;
    private final String[] suffixes;

    public ShapedBlockType(String s, Function<BlockBehaviour.Properties, Block> f, String ... su) {
        super(s);
        this.factory = f;
        this.suffixes = su;
    }

    @Override
    public Block createBlock(BlockBuilder builder) {
        return this.factory.apply(builder.createProperties());
    }

    @Override
    public void applyDefaults(BlockBuilder builder) {
        builder.notSolid();
        builder.waterlogged();
        builder.texture("texture", "kubejs:block/detector");
        for (String s : this.suffixes) {
            if (!builder.id.m_135815_().endsWith(s)) continue;
            builder.texture("texture", builder.id.m_135827_() + ":block/" + builder.id.m_135815_().substring(0, builder.id.m_135815_().length() - s.length()));
            break;
        }
        if (this == SLAB) {
            builder.tagBoth(BlockTags.f_13031_.m_6979_());
        } else if (this == STAIRS) {
            builder.tagBoth(BlockTags.f_13030_.m_6979_());
        } else if (this == FENCE) {
            builder.tagBoth(BlockTags.f_13039_.m_6979_());
            if (Platform.isForge()) {
                builder.tagBoth(new ResourceLocation("forge:fences"));
            }
        } else if (this == FENCE_GATE) {
            builder.tagBoth(BlockTags.f_13055_.m_6979_());
            if (Platform.isForge()) {
                builder.tagBoth(new ResourceLocation("forge:fence_gates"));
            }
        } else if (this == WALL) {
            builder.tagBoth(BlockTags.f_13032_.m_6979_());
        } else if (this == WOODEN_PRESSURE_PLATE) {
            builder.noCollission();
            builder.tagBoth(BlockTags.f_13099_.m_6979_());
            builder.tagBoth(BlockTags.f_13100_.m_6979_());
        } else if (this == STONE_PRESSURE_PLATE) {
            builder.noCollission();
            builder.tagBoth(BlockTags.f_13099_.m_6979_());
            builder.tagBoth(BlockTags.f_13101_.m_6979_());
        } else if (this == WOODEN_BUTTON) {
            builder.noCollission();
            builder.tagBoth(BlockTags.f_13093_.m_6979_());
            builder.tagBoth(BlockTags.f_13092_.m_6979_());
        } else if (this == STONE_BUTTON) {
            builder.noCollission();
            builder.tagBoth(BlockTags.f_13093_.m_6979_());
        }
    }

    @Override
    public void generateAssets(BlockBuilder builder, AssetJsonGenerator generator) {
        Block block = builder.block;
        if (block instanceof CustomBlockJS) {
            CustomBlockJS custom = (CustomBlockJS)block;
            custom.generateAssets(builder, generator);
        } else {
            super.generateAssets(builder, generator);
        }
    }
}

