/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.architectury.hooks.PackRepositoryHooks;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSCommon;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.client.ClientEventJS;
import dev.latvian.mods.kubejs.client.ClientWrapper;
import dev.latvian.mods.kubejs.client.KubeJSClientEventHandler;
import dev.latvian.mods.kubejs.client.KubeJSResourcePackFinder;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.level.ClientLevelJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.net.NetworkEventJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.rhino.util.unit.FixedUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class KubeJSClient
extends KubeJSCommon {
    @Override
    public void init() {
        if (Minecraft.m_91087_() == null) {
            return;
        }
        KubeJSClient.reloadClientScripts();
        new KubeJSClientEventHandler().init();
        PackRepository list = Minecraft.m_91087_().m_91099_();
        PackRepositoryHooks.addSource((PackRepository)list, (RepositorySource)new KubeJSResourcePackFinder());
        this.setup();
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::clientInit);
    }

    @Override
    public void reloadClientInternal() {
        KubeJSClient.reloadClientScripts();
    }

    public static void reloadClientScripts() {
        KubeJSClientEventHandler.staticItemTooltips = null;
        KubeJS.clientScriptManager.unload();
        KubeJS.clientScriptManager.loadFromDirectory();
        KubeJS.clientScriptManager.load();
    }

    public static void copyDefaultOptionsFile(File optionsFile) {
        Path defOptions;
        if (!optionsFile.exists() && Files.exists(defOptions = KubeJSPaths.CONFIG.resolve("defaultoptions.txt"), new LinkOption[0])) {
            try {
                KubeJS.LOGGER.info("Loaded default options from kubejs/config/defaultoptions.txt");
                Files.copy(defOptions, optionsFile.toPath(), new CopyOption[0]);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void clientBindings(BindingsEvent event) {
        event.add("Client", new ClientWrapper());
        event.add("Painter", Painter.INSTANCE);
    }

    @Override
    public void clientTypeWrappers(TypeWrappers typeWrappers) {
        typeWrappers.register(Unit.class, o -> {
            if (o instanceof Unit) {
                Unit unit = (Unit)o;
                return unit;
            }
            if (o instanceof Number) {
                Number number = (Number)o;
                return FixedUnit.of((float)number.floatValue());
            }
            if (o instanceof String) {
                return Painter.INSTANCE.unitStorage.parse(o.toString());
            }
            return FixedUnit.ZERO;
        });
    }

    private void setup() {
        new ClientEventJS().post("client.init");
    }

    @Override
    public void handleDataToClientPacket(String channel, @Nullable CompoundTag data) {
        new NetworkEventJS((Player)Minecraft.m_91087_().f_91074_, channel, data).post("player.data_from_server", channel);
    }

    @Override
    @Nullable
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public void paint(CompoundTag tag) {
        Painter.INSTANCE.paint(tag);
    }

    @Override
    public LevelJS getClientLevel() {
        return ClientLevelJS.getInstance();
    }

    private void reload(PreparableReloadListener listener) {
        long start = System.currentTimeMillis();
        Minecraft mc = Minecraft.m_91087_();
        listener.m_5540_(CompletableFuture::completedFuture, mc.m_91098_(), (ProfilerFiller)InactiveProfiler.f_18554_, (ProfilerFiller)InactiveProfiler.f_18554_, (Executor)Util.m_183991_(), (Executor)mc).thenAccept(unused -> mc.f_91074_.m_6352_((Component)new TextComponent("Done! You still may have to reload all assets with F3 + T"), Util.f_137441_));
    }

    @Override
    public void reloadTextures() {
        this.reload((PreparableReloadListener)Minecraft.m_91087_().m_91097_());
    }

    @Override
    public void reloadLang() {
        this.reload((PreparableReloadListener)Minecraft.m_91087_().m_91102_());
    }

    @Override
    public boolean isClientButNotSelf(Player player) {
        return player instanceof AbstractClientPlayer && !(player instanceof LocalPlayer);
    }
}

