/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTextureStitchEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.latvian.mods.kubejs.KubeJSObjects;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.client.ClientLoggedInEventJS;
import dev.latvian.mods.kubejs.client.ClientProperties;
import dev.latvian.mods.kubejs.client.ClientTickEventJS;
import dev.latvian.mods.kubejs.client.DebugInfoEventJS;
import dev.latvian.mods.kubejs.client.TagInstance;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPaintEventJS;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.mods.kubejs.client.painter.world.WorldPaintEventJS;
import dev.latvian.mods.kubejs.client.painter.world.WorldPainterObject;
import dev.latvian.mods.kubejs.core.BucketItemKJS;
import dev.latvian.mods.kubejs.core.ImageButtonKJS;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemTooltipEventJS;
import dev.latvian.mods.kubejs.level.ClientLevelJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.Tags;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class KubeJSClientEventHandler {
    private static final ResourceLocation RECIPE_BUTTON_TEXTURE = new ResourceLocation("textures/gui/recipe_button.png");
    public static Map<Item, List<ItemTooltipEventJS.StaticTooltipHandler>> staticItemTooltips = null;
    private final Map<ResourceLocation, TagInstance> tempTagNames = new LinkedHashMap<ResourceLocation, TagInstance>();

    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::clientSetup);
        ClientGuiEvent.DEBUG_TEXT_LEFT.register(this::debugInfoLeft);
        ClientGuiEvent.DEBUG_TEXT_RIGHT.register(this::debugInfoRight);
        ClientTooltipEvent.ITEM.register(this::itemTooltip);
        ClientTickEvent.CLIENT_POST.register(this::clientTick);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(this::loggedIn);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        ClientPlayerEvent.CLIENT_PLAYER_RESPAWN.register(this::respawn);
        ClientGuiEvent.RENDER_HUD.register(this::inGameScreenDraw);
        ClientGuiEvent.RENDER_POST.register(this::guiScreenDraw);
        ClientGuiEvent.INIT_POST.register(this::guiPostInit);
        ClientTextureStitchEvent.POST.register(this::postAtlasStitch);
    }

    private void clientSetup(Minecraft minecraft) {
        this.renderLayers();
        this.blockColors();
        this.itemColors();
    }

    private void renderLayers() {
        for (BlockBuilder builder : KubeJSObjects.BLOCKS.values()) {
            switch (builder.renderType) {
                case "cutout": {
                    RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{builder.block});
                    break;
                }
                case "cutout_mipped": {
                    RenderTypeRegistry.register((RenderType)RenderType.m_110457_(), (Block[])new Block[]{builder.block});
                    break;
                }
                case "translucent": {
                    RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{builder.block});
                }
            }
        }
    }

    private void debugInfoLeft(List<String> lines) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            new DebugInfoEventJS(lines).post(ScriptType.CLIENT, "client.debug_info.left");
        }
    }

    private void debugInfoRight(List<String> lines) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            new DebugInfoEventJS(lines).post(ScriptType.CLIENT, "client.debug_info.right");
        }
    }

    private void itemTooltip(ItemStack stack, List<Component> lines, TooltipFlag flag) {
        boolean advanced = flag.m_7050_();
        if (advanced && ClientProperties.get().getShowTagNames() && Screen.m_96638_()) {
            Item item;
            Item item2;
            Object item3;
            for (ResourceLocation resourceLocation : Tags.byItemStack(stack)) {
                this.tempTagNames.computeIfAbsent((ResourceLocation)resourceLocation, (Function<ResourceLocation, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Ldev/latvian/mods/kubejs/client/TagInstance;)()).item = true;
            }
            Item item4 = stack.m_41720_();
            if (item4 instanceof BlockItem) {
                item3 = (BlockItem)item4;
                for (ResourceLocation tag3 : Tags.byBlock(item3.m_40614_())) {
                    this.tempTagNames.computeIfAbsent((ResourceLocation)tag3, (Function<ResourceLocation, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Ldev/latvian/mods/kubejs/client/TagInstance;)()).block = true;
                }
            }
            if ((item2 = stack.m_41720_()) instanceof BucketItemKJS) {
                item3 = (BucketItemKJS)item2;
                for (ResourceLocation tag : Tags.byFluid(item3.getFluidKJS())) {
                    this.tempTagNames.computeIfAbsent((ResourceLocation)tag, (Function<ResourceLocation, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Ldev/latvian/mods/kubejs/client/TagInstance;)()).fluid = true;
                }
            }
            if ((item = stack.m_41720_()) instanceof SpawnEggItem) {
                item3 = (SpawnEggItem)item;
                for (ResourceLocation tag : Tags.byEntityType(item3.m_43228_(stack.m_41783_()))) {
                    this.tempTagNames.computeIfAbsent((ResourceLocation)tag, (Function<ResourceLocation, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Ldev/latvian/mods/kubejs/client/TagInstance;)()).entity = true;
                }
            }
            for (TagInstance tagInstance : this.tempTagNames.values()) {
                lines.add(tagInstance.toText());
            }
            this.tempTagNames.clear();
        }
        if (staticItemTooltips == null) {
            staticItemTooltips = new HashMap<Item, List<ItemTooltipEventJS.StaticTooltipHandler>>();
            new ItemTooltipEventJS(staticItemTooltips).post(ScriptType.CLIENT, "item.tooltip");
        }
        for (ItemTooltipEventJS.StaticTooltipHandler staticTooltipHandler : staticItemTooltips.getOrDefault(Items.f_41852_, Collections.emptyList())) {
            staticTooltipHandler.tooltip(stack, advanced, lines);
        }
        for (ItemTooltipEventJS.StaticTooltipHandler staticTooltipHandler : staticItemTooltips.getOrDefault(stack.m_41720_(), Collections.emptyList())) {
            staticTooltipHandler.tooltip(stack, advanced, lines);
        }
    }

    private void clientTick(Minecraft minecraft) {
        if (Minecraft.m_91087_().f_91074_ != null && ClientLevelJS.getInstance() != null) {
            new ClientTickEventJS().post("client.tick");
        }
    }

    private void loggedIn(LocalPlayer player) {
        ClientLevelJS.setInstance(new ClientLevelJS(Minecraft.m_91087_(), player));
        AttachDataEvent.forLevel(ClientLevelJS.getInstance()).invoke();
        AttachDataEvent.forPlayer(ClientLevelJS.getInstance().clientPlayerData).invoke();
        new ClientLoggedInEventJS().post("client.logged_in");
    }

    private void loggedOut(LocalPlayer player) {
        if (ClientLevelJS.getInstance() != null) {
            new ClientLoggedInEventJS().post("client.logged_out");
        }
        ClientLevelJS.setInstance(null);
        Painter.INSTANCE.clear();
    }

    private void respawn(LocalPlayer oldPlayer, LocalPlayer newPlayer) {
        ClientLevelJS.setInstance(new ClientLevelJS(Minecraft.m_91087_(), newPlayer));
        AttachDataEvent.forLevel(ClientLevelJS.getInstance()).invoke();
        AttachDataEvent.forPlayer(ClientLevelJS.getInstance().clientPlayerData).invoke();
    }

    private void inGameScreenDraw(PoseStack matrices, float delta) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91066_.f_92063_ || mc.f_91080_ != null) {
            return;
        }
        RenderSystem.m_69478_();
        ScreenPaintEventJS event = new ScreenPaintEventJS(mc, matrices, delta);
        Painter.INSTANCE.deltaUnit.set(delta);
        Painter.INSTANCE.screenWidthUnit.set((float)event.width);
        Painter.INSTANCE.screenHeightUnit.set((float)event.height);
        Painter.INSTANCE.mouseXUnit.set((float)event.mouseX);
        Painter.INSTANCE.mouseYUnit.set((float)event.mouseY);
        event.post("client.paint_screen");
        for (ScreenPainterObject object : Painter.INSTANCE.getScreenObjects()) {
            if (!object.visible || object.draw != 0 && object.draw != 1) continue;
            object.preDraw(event);
        }
        for (ScreenPainterObject object : Painter.INSTANCE.getScreenObjects()) {
            if (!object.visible || object.draw != 0 && object.draw != 1) continue;
            object.draw(event);
        }
    }

    private void guiScreenDraw(Screen screen, PoseStack matrices, int mouseX, int mouseY, float delta) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        RenderSystem.m_69478_();
        ScreenPaintEventJS event = new ScreenPaintEventJS(mc, screen, matrices, mouseX, mouseY, delta);
        event.post("client.paint_screen");
        for (ScreenPainterObject object : Painter.INSTANCE.getScreenObjects()) {
            if (!object.visible || object.draw != 0 && object.draw != 2) continue;
            object.preDraw(event);
        }
        for (ScreenPainterObject object : Painter.INSTANCE.getScreenObjects()) {
            if (!object.visible || object.draw != 0 && object.draw != 2) continue;
            object.draw(event);
        }
    }

    private boolean isOver(List<AbstractWidget> list, int x, int y) {
        for (AbstractWidget w : list) {
            if (!w.f_93624_ || x < w.f_93620_ || y < w.f_93621_ || x >= w.f_93620_ + w.m_5711_() || y >= w.f_93621_ + w.m_93694_()) continue;
            return true;
        }
        return false;
    }

    private void guiPostInit(Screen screen, ScreenAccess access) {
        if (ClientProperties.get().getDisableRecipeBook() && screen instanceof RecipeUpdateListener) {
            Iterator iterator = screen.m_6702_().iterator();
            while (iterator.hasNext()) {
                ImageButtonKJS buttonKJS;
                GuiEventListener listener = (GuiEventListener)iterator.next();
                if (!(listener instanceof AbstractWidget) || !(listener instanceof ImageButtonKJS) || !RECIPE_BUTTON_TEXTURE.equals((Object)(buttonKJS = (ImageButtonKJS)listener).getButtonTextureKJS())) continue;
                access.getRenderables().remove(listener);
                access.getNarratables().remove(listener);
                iterator.remove();
                return;
            }
        }
    }

    private void itemColors() {
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            if (itemBuilder.color.isEmpty()) continue;
            ColorHandlerRegistry.registerItemColors((stack, index) -> builder.color.get(index), (ItemLike[])new ItemLike[]{(ItemLike)Objects.requireNonNull(itemBuilder.item, "Item " + itemBuilder.id + " is null!")});
        }
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            if (blockBuilder.itemBuilder == null || blockBuilder.color.isEmpty()) continue;
            ColorHandlerRegistry.registerItemColors((stack, index) -> builder.color.get(index), (ItemLike[])new ItemLike[]{(ItemLike)Objects.requireNonNull(blockBuilder.itemBuilder.blockItem, "Block Item " + blockBuilder.id + " is null!")});
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            if (fluidBuilder.bucketColor == -1) continue;
            ColorHandlerRegistry.registerItemColors((stack, index) -> index == 1 ? builder.bucketColor : -1, (ItemLike[])new ItemLike[]{(ItemLike)Objects.requireNonNull(fluidBuilder.bucketItem, "Bucket Item " + fluidBuilder.id + " is null!")});
        }
    }

    private void blockColors() {
        for (BlockBuilder builder : KubeJSObjects.BLOCKS.values()) {
            if (builder.color.isEmpty()) continue;
            ColorHandlerRegistry.registerBlockColors((state, level, pos, index) -> builder.color.get(index), (Block[])new Block[]{builder.block});
        }
    }

    private void postAtlasStitch(TextureAtlas atlas) {
        if (!ClientProperties.get().getExportAtlases()) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)atlas.m_117963_());
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        if (w <= 0 || h <= 0) {
            return;
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        int[] pixels = new int[w * h];
        IntBuffer result = BufferUtils.createIntBuffer((int)(w * h));
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)result);
        result.get(pixels);
        image.setRGB(0, 0, w, h, pixels, 0, w);
        Path path = KubeJSPaths.EXPORTED.resolve(atlas.m_118330_().m_135827_() + "/" + atlas.m_118330_().m_135815_());
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        try (OutputStream stream = Files.newOutputStream(path, new OpenOption[0]);){
            ImageIO.write((RenderedImage)image, "PNG", stream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void renderWorldLast(PoseStack ps, float delta) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        WorldPaintEventJS event = new WorldPaintEventJS(mc, ps, delta);
        event.post("client.paint_world");
        for (WorldPainterObject object : Painter.INSTANCE.getWorldObjects()) {
            if (!object.visible) continue;
            object.preDraw(event);
        }
        for (WorldPainterObject object : Painter.INSTANCE.getWorldObjects()) {
            if (!object.visible) continue;
            object.draw(event);
        }
    }
}

