/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.painter;

import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import dev.latvian.mods.rhino.util.unit.ColorUnit;
import dev.latvian.mods.rhino.util.unit.FixedUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PainterObjectProperties {
    public static final Unit WHITE_COLOR = new ColorUnit((Unit)FixedUnit.of((float)255.0f), (Unit)FixedUnit.of((float)255.0f), (Unit)FixedUnit.of((float)255.0f), (Unit)FixedUnit.of((float)255.0f));
    public final CompoundTag tag;

    public PainterObjectProperties(CompoundTag t) {
        this.tag = t;
    }

    public boolean hasAny(String key) {
        return this.tag.m_128441_(key);
    }

    public boolean has(String key, int type) {
        return this.tag.m_128425_(key, type);
    }

    public boolean hasNumber(String key) {
        return this.tag.m_128425_(key, 99);
    }

    public boolean hasString(String key) {
        return this.tag.m_128425_(key, 8);
    }

    public String getString(String key, String def) {
        return this.has(key, 8) ? this.tag.m_128461_(key) : def;
    }

    @Nullable
    public ResourceLocation getResourceLocation(String key, @Nullable ResourceLocation def) {
        String s = this.getString(key, "").trim();
        return s.isEmpty() ? def : new ResourceLocation(s);
    }

    public int getInt(String key, int def) {
        return this.hasNumber(key) ? this.tag.m_128451_(key) : def;
    }

    public float getFloat(String key, float def) {
        return this.hasNumber(key) ? this.tag.m_128457_(key) : def;
    }

    public double getDouble(String key, double def) {
        return this.hasNumber(key) ? this.tag.m_128459_(key) : def;
    }

    public boolean getBoolean(String key, boolean def) {
        return this.hasNumber(key) ? this.tag.m_128471_(key) : def;
    }

    public Unit getUnit(String key, Unit def) {
        if (this.hasString(key)) {
            return Painter.INSTANCE.unitStorage.parse(this.tag.m_128461_(key));
        }
        if (this.hasNumber(key)) {
            return FixedUnit.of((float)this.tag.m_128457_(key));
        }
        return def;
    }

    public Unit getColor(String key, Unit def) {
        Color col;
        if (this.hasString(key) && (col = (Color)ColorWrapper.MAP.get(this.getString(key, ""))) != null) {
            int i = col.getArgbKJS();
            return new ColorUnit((Unit)FixedUnit.of((float)(i >> 16 & 0xFF)), (Unit)FixedUnit.of((float)(i >> 8 & 0xFF)), (Unit)FixedUnit.of((float)(i & 0xFF)), (Unit)FixedUnit.of((float)(i >> 24 & 0xFF)));
        }
        return this.getUnit(key, def);
    }
}

