/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.painter.screen;

import dev.latvian.mods.kubejs.client.painter.PainterObject;
import dev.latvian.mods.kubejs.client.painter.PainterObjectProperties;
import dev.latvian.mods.kubejs.client.painter.PainterObjectStorage;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPaintEventJS;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.mods.rhino.util.unit.FixedUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ScreenGroup
extends ScreenPainterObject {
    private final PainterObjectStorage storage = new PainterObjectStorage();
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float scaleZ = 1.0f;
    private Unit paddingW = FixedUnit.ZERO;
    private Unit paddingH = FixedUnit.ZERO;

    @Override
    protected void load(PainterObjectProperties properties) {
        super.load(properties);
        Tag c = properties.tag.m_128423_("children");
        if (c instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)c;
            this.storage.handle(tag);
        }
        this.scaleX = properties.getFloat("scaleX", this.scaleX);
        this.scaleY = properties.getFloat("scaleY", this.scaleY);
        this.scaleZ = properties.getFloat("scaleZ", this.scaleZ);
        this.paddingW = properties.getUnit("paddingW", this.paddingW);
        this.paddingH = properties.getUnit("paddingH", this.paddingH);
        if (properties.hasNumber("scale")) {
            this.scaleX = this.scaleY = properties.getFloat("scale", 1.0f);
        }
    }

    @Override
    public void preDraw(ScreenPaintEventJS event) {
        this.w = FixedUnit.ZERO;
        this.h = FixedUnit.ZERO;
        for (PainterObject object : this.storage.getObjects()) {
            if (!(object instanceof ScreenPainterObject)) continue;
            ScreenPainterObject s = (ScreenPainterObject)object;
            s.preDraw(event);
            this.w = this.w.max(s.x.add(s.w));
            this.h = this.h.max(s.y.add(s.h));
        }
        this.w = this.w.add(this.paddingW);
        this.h = this.w.add(this.paddingH);
    }

    @Override
    public void draw(ScreenPaintEventJS event) {
        float ax = event.alignX(this.x.get(), this.w.get(), this.alignX);
        float ay = event.alignY(this.y.get(), this.h.get(), this.alignY);
        float az = this.z.get();
        event.push();
        event.translate(ax, ay, az);
        event.scale(this.scaleX, this.scaleY, this.scaleZ);
        for (PainterObject object : this.storage.getObjects()) {
            if (!(object instanceof ScreenPainterObject)) continue;
            ScreenPainterObject s = (ScreenPainterObject)object;
            s.draw(event);
        }
        event.pop();
    }
}

