/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.painter.screen;

import dev.latvian.mods.kubejs.client.painter.PainterObjectProperties;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPaintEventJS;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.mods.kubejs.text.Text;
import dev.latvian.mods.rhino.util.unit.FixedUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import net.minecraft.util.FormattedCharSequence;

public class TextObject
extends ScreenPainterObject {
    private FormattedCharSequence text = FormattedCharSequence.f_13691_;
    private boolean shadow = false;
    private float scale = 1.0f;
    private Unit color = PainterObjectProperties.WHITE_COLOR;
    private boolean centered = false;
    private float textWidth;

    @Override
    protected void load(PainterObjectProperties properties) {
        super.load(properties);
        this.text = Text.componentOf(properties.tag.m_128423_("text")).m_7532_();
        this.shadow = properties.getBoolean("shadow", this.shadow);
        this.scale = properties.getFloat("scale", this.scale);
        this.color = properties.getColor("color", this.color);
        this.centered = properties.getBoolean("centered", this.centered);
    }

    @Override
    public void preDraw(ScreenPaintEventJS event) {
        this.textWidth = event.font.m_92865_().m_92336_(this.text);
        this.w = FixedUnit.of((float)(this.textWidth * this.scale));
        this.h = FixedUnit.of((float)(9.0f * this.scale));
    }

    @Override
    public void draw(ScreenPaintEventJS event) {
        float aw = this.w.get();
        float ah = this.h.get();
        float ax = event.alignX(this.x.get(), aw, this.alignX);
        float ay = event.alignY(this.y.get(), ah, this.alignY);
        float az = this.z.get();
        if (this.scale == 1.0f && az == 0.0f) {
            if (this.centered) {
                event.rawText(this.text, ax - this.textWidth / 2.0f, ay, this.color.getAsInt(), this.shadow);
            } else {
                event.rawText(this.text, ax, ay, this.color.getAsInt(), this.shadow);
            }
        } else {
            event.push();
            event.translate(ax, ay, az);
            event.scale(this.scale);
            if (this.centered) {
                event.rawText(this.text, -this.textWidth / 2.0f, 0.0f, this.color.getAsInt(), this.shadow);
            } else {
                event.rawText(this.text, 0.0f, 0.0f, this.color.getAsInt(), this.shadow);
            }
            event.pop();
        }
    }
}

