/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.core.MinecraftServerKJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.GroupIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.ModIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.mods.kubejs.net.PaintMessage;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.CustomCommandEventJS;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.stages.Stages;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.ReloadCommand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.WorldData;

public class KubeJSCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"kubejs").then(Commands.m_82127_((String)"custom_command").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).executes(context -> KubeJSCommands.customCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id")))))).then(Commands.m_82127_((String)"hand").executes(context -> KubeJSCommands.hand(((CommandSourceStack)context.getSource()).m_81375_(), InteractionHand.MAIN_HAND)))).then(Commands.m_82127_((String)"offhand").executes(context -> KubeJSCommands.hand(((CommandSourceStack)context.getSource()).m_81375_(), InteractionHand.OFF_HAND)))).then(Commands.m_82127_((String)"inventory").executes(context -> KubeJSCommands.inventory(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82127_((String)"hotbar").executes(context -> KubeJSCommands.hotbar(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82127_((String)"errors").executes(context -> KubeJSCommands.errors((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"warnings").executes(context -> KubeJSCommands.warnings((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"startup_scripts").requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).executes(context -> KubeJSCommands.reloadStartup((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"server_scripts").requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).executes(context -> KubeJSCommands.reloadServer((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"client_scripts").requires(source -> true)).executes(context -> KubeJSCommands.reloadClient((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"textures").requires(source -> true)).executes(context -> KubeJSCommands.reloadTextures((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"lang").requires(source -> true)).executes(context -> KubeJSCommands.reloadLang((CommandSourceStack)context.getSource()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export").requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).executes(context -> KubeJSCommands.export((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"list_tag").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"tag", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> KubeJSCommands.tagObjects(((CommandSourceStack)context.getSource()).m_81375_(), Tags.items(), Registry.f_122904_, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"tag")))).then(Commands.m_82127_((String)"item").executes(context -> KubeJSCommands.tagObjects(((CommandSourceStack)context.getSource()).m_81375_(), Tags.items(), Registry.f_122904_, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"tag"))))).then(Commands.m_82127_((String)"block").executes(context -> KubeJSCommands.tagObjects(((CommandSourceStack)context.getSource()).m_81375_(), Tags.blocks(), Registry.f_122901_, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"tag"))))).then(Commands.m_82127_((String)"fluid").executes(context -> KubeJSCommands.tagObjects(((CommandSourceStack)context.getSource()).m_81375_(), Tags.fluids(), Registry.f_122899_, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"tag"))))).then(Commands.m_82127_((String)"entity_type").executes(context -> KubeJSCommands.tagObjects(((CommandSourceStack)context.getSource()).m_81375_(), Tags.entityTypes(), Registry.f_122903_, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"tag"))))))).then(Commands.m_82127_((String)"wiki").executes(context -> KubeJSCommands.wiki((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stages").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.addStage((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.removeStage((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> KubeJSCommands.clearStages((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> KubeJSCommands.listStages((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"))))))).then(Commands.m_82127_((String)"painter").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"object", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> KubeJSCommands.painter((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), CompoundTagArgument.m_87660_((CommandContext)context, (String)"object")))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"kjs_hand").executes(context -> KubeJSCommands.hand(((CommandSourceStack)context.getSource()).m_81375_(), InteractionHand.MAIN_HAND)));
    }

    private static Component copy(String s, ChatFormatting col, String info) {
        TextComponent component = new TextComponent("- ");
        component.m_6270_(component.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)));
        component.m_6270_(component.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)));
        component.m_6270_(component.m_7383_().m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(info + " (Click to copy)"))));
        component.m_7220_((Component)new TextComponent(s).m_130940_(col));
        return component;
    }

    private static int customCommand(CommandSourceStack source, String id) {
        new CustomCommandEventJS((Level)source.m_81372_(), source.m_81373_(), new BlockPos(source.m_81371_()), id).post(ScriptType.SERVER, "server.custom_command", id);
        return 1;
    }

    private static int hand(ServerPlayer player, InteractionHand hand) {
        player.m_6352_((Component)new TextComponent("Item in hand:"), Util.f_137441_);
        ItemStackJS stack = ItemStackJS.of(player.m_21120_(hand));
        player.m_6352_(KubeJSCommands.copy(stack.toString(), ChatFormatting.GREEN, "Item ID"), Util.f_137441_);
        ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>(Tags.byItem(stack.getItem()));
        tags.sort(null);
        for (ResourceLocation id : tags) {
            player.m_6352_(KubeJSCommands.copy("'#" + id + "'", ChatFormatting.YELLOW, "Item Tag [" + TagIngredientJS.createTag(id.toString()).getStacks().size() + " items]"), Util.f_137441_);
        }
        player.m_6352_(KubeJSCommands.copy("'@" + stack.getMod() + "'", ChatFormatting.AQUA, "Mod [" + new ModIngredientJS(stack.getMod()).getStacks().size() + " items]"), Util.f_137441_);
        if (stack.getItem().m_41471_() != null) {
            player.m_6352_(KubeJSCommands.copy("'%" + stack.getItemGroup() + "'", ChatFormatting.LIGHT_PURPLE, "Item Group [" + new GroupIngredientJS(stack.getItem().m_41471_()).getStacks().size() + " items]"), Util.f_137441_);
        }
        return 1;
    }

    private static int inventory(ServerPlayer player) {
        return KubeJSCommands.dump((List<ItemStack>)player.m_150109_().f_35974_, player, "Inventory");
    }

    private static int hotbar(ServerPlayer player) {
        return KubeJSCommands.dump(player.m_150109_().f_35974_.subList(0, 9), player, "Hotbar");
    }

    private static int dump(List<ItemStack> stacks, ServerPlayer player, String name) {
        ArrayList<ItemStackJS> stackList = new ArrayList<ItemStackJS>(stacks.size());
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            stackList.add(ItemStackJS.of(stack));
        }
        String dump = ((Object)stackList).toString();
        player.m_6352_(KubeJSCommands.copy(dump, ChatFormatting.WHITE, name + " Item List"), Util.f_137441_);
        return 1;
    }

    private static int errors(CommandSourceStack source) {
        if (ScriptType.SERVER.errors.isEmpty()) {
            source.m_81354_((Component)new TextComponent("No errors found!").m_130940_(ChatFormatting.GREEN), false);
            if (!ScriptType.SERVER.warnings.isEmpty()) {
                source.m_81354_((Component)new TextComponent(ScriptType.SERVER.warnings.size() + " warnings found. Run /kubejs warnings to see them").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16753920))), false);
            }
            return 1;
        }
        for (int i = 0; i < ScriptType.SERVER.errors.size(); ++i) {
            source.m_81354_((Component)new TextComponent("[" + (i + 1) + "] " + ScriptType.SERVER.errors.get(i)).m_130940_(ChatFormatting.RED), false);
        }
        source.m_81354_((Component)new TextComponent("More info in 'logs/kubejs/server.txt'").m_130940_(ChatFormatting.DARK_RED), false);
        if (!ScriptType.SERVER.warnings.isEmpty()) {
            source.m_81354_((Component)new TextComponent(ScriptType.SERVER.warnings.size() + " warnings found. Run '/kubejs warnings' to see them").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16753920))), false);
        }
        return 1;
    }

    private static int warnings(CommandSourceStack source) {
        if (ScriptType.SERVER.warnings.isEmpty()) {
            source.m_81354_((Component)new TextComponent("No warnings found!").m_130940_(ChatFormatting.GREEN), false);
            return 1;
        }
        for (int i = 0; i < ScriptType.SERVER.warnings.size(); ++i) {
            source.m_81354_((Component)new TextComponent("[" + (i + 1) + "] " + ScriptType.SERVER.warnings.get(i)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16753920))), false);
        }
        return 1;
    }

    private static int reloadStartup(CommandSourceStack source) {
        KubeJS.startupScriptManager.unload();
        KubeJS.startupScriptManager.loadFromDirectory();
        KubeJS.startupScriptManager.load();
        UtilsJS.postModificationEvents();
        source.m_81354_((Component)new TextComponent("Done!"), false);
        return 1;
    }

    private static int reloadServer(CommandSourceStack source) {
        ServerScriptManager.instance.reloadScriptManager(((MinecraftServerKJS)source.m_81377_()).getServerResourcesKJS().m_136178_());
        UtilsJS.postModificationEvents();
        source.m_81354_((Component)new TextComponent("Done! To reload recipes, tags, loot tables and other datapack things, run /reload"), false);
        return 1;
    }

    private static int reloadClient(CommandSourceStack source) {
        KubeJS.PROXY.reloadClientInternal();
        source.m_81354_((Component)new TextComponent("Done! To reload textures, models and other assets, press F3 + T"), false);
        return 1;
    }

    private static int reloadTextures(CommandSourceStack source) {
        KubeJS.PROXY.reloadTextures();
        return 1;
    }

    private static int reloadLang(CommandSourceStack source) {
        KubeJS.PROXY.reloadLang();
        return 1;
    }

    private static int export(CommandSourceStack source) {
        if (ServerSettings.dataExport != null) {
            return 0;
        }
        ServerSettings.source = source;
        ServerSettings.dataExport = new JsonObject();
        source.m_81354_((Component)new TextComponent("Reloading server and exporting data..."), false);
        MinecraftServer minecraftServer = source.m_81377_();
        PackRepository packRepository = minecraftServer.m_129891_();
        WorldData worldData = minecraftServer.m_129910_();
        Collection collection = packRepository.m_10523_();
        packRepository.m_10506_();
        ArrayList collection2 = Lists.newArrayList((Iterable)collection);
        List collection3 = worldData.m_7513_().m_45855_();
        for (String string : packRepository.m_10514_()) {
            if (collection3.contains(string) || collection2.contains(string)) continue;
            collection2.add(string);
        }
        ReloadCommand.m_138235_((Collection)collection2, (CommandSourceStack)source);
        return 1;
    }

    private static int outputRecipes(ServerPlayer player) {
        player.m_6352_((Component)new TextComponent("WIP!"), Util.f_137441_);
        return 1;
    }

    private static int inputRecipes(ServerPlayer player) {
        player.m_6352_((Component)new TextComponent("WIP!"), Util.f_137441_);
        return 1;
    }

    private static int checkRecipeConflicts(ServerPlayer player) {
        player.m_6352_((Component)new TextComponent("WIP!"), Util.f_137441_);
        return 1;
    }

    private static <T> int tagObjects(ServerPlayer player, TagCollection<T> collection, ResourceKey<Registry<T>> reg, ResourceLocation t) {
        Tag tag = collection.m_13404_(t);
        if (tag == null || tag.m_6497_().isEmpty()) {
            player.m_6352_((Component)new TextComponent("Tag not found!"), Util.f_137441_);
            return 0;
        }
        player.m_6352_((Component)new TextComponent(t + ":"), Util.f_137441_);
        for (Object item : tag.m_6497_()) {
            ResourceLocation id = Registries.getId(item, reg);
            if (id == null) {
                player.m_6352_((Component)new TextComponent("- " + item), Util.f_137441_);
                continue;
            }
            player.m_6352_((Component)new TextComponent("- " + id), Util.f_137441_);
        }
        player.m_6352_((Component)new TextComponent(tag.m_6497_().size() + " elements"), Util.f_137441_);
        return 1;
    }

    private static int wiki(CommandSourceStack source) {
        source.m_81354_((Component)new TextComponent("Click here to open the Wiki").m_130940_(ChatFormatting.BLUE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://kubejs.com/"))), false);
        return 1;
    }

    private static int addStage(CommandSourceStack source, Collection<ServerPlayer> players, String stage) {
        for (ServerPlayer p : players) {
            if (!Stages.get((Player)p).add(stage)) continue;
            source.m_81354_((Component)new TextComponent("Added '" + stage + "' stage for " + p.m_6302_()), false);
        }
        return 1;
    }

    private static int removeStage(CommandSourceStack source, Collection<ServerPlayer> players, String stage) {
        for (ServerPlayer p : players) {
            if (!Stages.get((Player)p).remove(stage)) continue;
            source.m_81354_((Component)new TextComponent("Removed '" + stage + "' stage for " + p.m_6302_()), false);
        }
        return 1;
    }

    private static int clearStages(CommandSourceStack source, Collection<ServerPlayer> players) {
        for (ServerPlayer p : players) {
            if (!Stages.get((Player)p).clear()) continue;
            source.m_81354_((Component)new TextComponent("Cleared stages for " + p.m_6302_()), false);
        }
        return 1;
    }

    private static int listStages(CommandSourceStack source, Collection<ServerPlayer> players) {
        for (ServerPlayer p : players) {
            source.m_81354_((Component)new TextComponent(p.m_6302_() + " stages:"), false);
            Stages.get((Player)p).getAll().stream().sorted().forEach(s -> source.m_81354_((Component)new TextComponent("- " + s), false));
        }
        return 1;
    }

    private static int painter(CommandSourceStack source, Collection<ServerPlayer> players, CompoundTag object) {
        new PaintMessage(object).sendTo(players);
        return 1;
    }
}

