/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.entity;

import com.mojang.authlib.GameProfile;
import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.core.EntityKJS;
import dev.latvian.mods.kubejs.entity.RayTraceResultJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.level.ServerLevelJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.text.Text;
import dev.latvian.mods.kubejs.util.MessageSender;
import dev.latvian.mods.kubejs.util.WrappedJS;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public class EntityJS
implements MessageSender,
WrappedJS {
    private static Map<String, DamageSource> damageSourceMap;
    private final LevelJS level;
    public final Entity minecraftEntity;
    public final CompoundTag persistentData;

    public EntityJS(LevelJS l, Entity e) {
        this.level = l;
        this.minecraftEntity = e;
        this.persistentData = ((EntityKJS)e).getPersistentDataKJS();
    }

    public final LevelJS getLevel() {
        return this.level;
    }

    @Nullable
    public ServerJS getServer() {
        return this.getLevel().getServer();
    }

    public UUID getId() {
        return this.minecraftEntity.m_142081_();
    }

    public String getType() {
        return Registries.getId((Object)this.minecraftEntity.m_6095_(), (ResourceKey)Registry.f_122903_).toString();
    }

    @Override
    public Text getName() {
        return Text.of(this.minecraftEntity.m_7755_());
    }

    public GameProfile getProfile() {
        return new GameProfile(this.getId(), this.minecraftEntity.m_20078_());
    }

    @Override
    public Text getDisplayName() {
        return Text.of(this.minecraftEntity.m_5446_());
    }

    @Override
    public void tell(Component message) {
        this.minecraftEntity.m_6352_(message, Util.f_137441_);
    }

    public String toString() {
        return this.minecraftEntity.m_7755_().getString() + "-" + this.getId();
    }

    @Nullable
    public ItemStackJS getItem() {
        return null;
    }

    public boolean isFrame() {
        return false;
    }

    public Set<String> getTags() {
        return this.minecraftEntity.m_19880_();
    }

    public boolean isAlive() {
        return this.minecraftEntity.m_6084_();
    }

    public boolean isLiving() {
        return false;
    }

    public boolean isPlayer() {
        return false;
    }

    public boolean isCrouching() {
        return this.minecraftEntity.m_6047_();
    }

    public boolean isSprinting() {
        return this.minecraftEntity.m_20142_();
    }

    public boolean isSwimming() {
        return this.minecraftEntity.m_6069_();
    }

    public boolean isGlowing() {
        return this.minecraftEntity.m_142038_();
    }

    public void setGlowing(boolean glowing) {
        this.minecraftEntity.m_146915_(glowing);
    }

    public boolean isInvisible() {
        return this.minecraftEntity.m_20145_();
    }

    public void setInvisible(boolean invisible) {
        this.minecraftEntity.m_6842_(invisible);
    }

    public boolean isInvulnerable() {
        return this.minecraftEntity.m_20147_();
    }

    public void setInvulnerable(boolean invulnerable) {
        this.minecraftEntity.m_20331_(invulnerable);
    }

    public boolean isBoss() {
        return !this.minecraftEntity.m_6072_();
    }

    public boolean isMonster() {
        return !this.minecraftEntity.m_6095_().m_20674_().m_21609_();
    }

    public boolean isAnimal() {
        return this.minecraftEntity.m_6095_().m_20674_().m_21610_();
    }

    public boolean isAmbientCreature() {
        return this.minecraftEntity.m_6095_().m_20674_() == MobCategory.AMBIENT;
    }

    public boolean isWaterCreature() {
        return this.minecraftEntity.m_6095_().m_20674_() == MobCategory.WATER_CREATURE;
    }

    public boolean isPeacefulCreature() {
        return this.minecraftEntity.m_6095_().m_20674_().m_21609_();
    }

    public boolean isOnGround() {
        return this.minecraftEntity.m_20096_();
    }

    public float getFallDistance() {
        return this.minecraftEntity.f_19789_;
    }

    public void setFallDistance(float fallDistance) {
        this.minecraftEntity.f_19789_ = fallDistance;
    }

    public float getStepHeight() {
        return this.minecraftEntity.f_19793_;
    }

    public void setStepHeight(float stepHeight) {
        this.minecraftEntity.f_19793_ = stepHeight;
    }

    public boolean getNoClip() {
        return this.minecraftEntity.f_19794_;
    }

    public void setNoClip(boolean noClip) {
        this.minecraftEntity.f_19794_ = noClip;
    }

    public boolean isSilent() {
        return this.minecraftEntity.m_20067_();
    }

    public void setSilent(boolean isSilent) {
        this.minecraftEntity.m_20225_(isSilent);
    }

    public boolean getNoGravity() {
        return this.minecraftEntity.m_20068_();
    }

    public void setNoGravity(boolean noGravity) {
        this.minecraftEntity.m_20242_(noGravity);
    }

    public double getX() {
        return this.minecraftEntity.m_20185_();
    }

    public void setX(double x) {
        this.minecraftEntity.m_6034_(x, this.getY(), this.getZ());
    }

    public double getY() {
        return this.minecraftEntity.m_20186_();
    }

    public void setY(double y) {
        this.minecraftEntity.m_6034_(this.getX(), y, this.getZ());
    }

    public double getZ() {
        return this.minecraftEntity.m_20189_();
    }

    public void setZ(double z) {
        this.minecraftEntity.m_6034_(this.getX(), this.getY(), z);
    }

    public float getYaw() {
        return this.minecraftEntity.m_146908_();
    }

    public void setYaw(float yaw) {
        this.minecraftEntity.m_146922_(yaw);
    }

    public float getPitch() {
        return this.minecraftEntity.m_146909_();
    }

    public void setPitch(float pitch) {
        this.minecraftEntity.m_146926_(pitch);
    }

    public double getMotionX() {
        return this.minecraftEntity.m_20184_().f_82479_;
    }

    public void setMotionX(double x) {
        Vec3 m = this.minecraftEntity.m_20184_();
        this.minecraftEntity.m_20334_(x, m.f_82480_, m.f_82481_);
    }

    public double getMotionY() {
        return this.minecraftEntity.m_20184_().f_82480_;
    }

    public void setMotionY(double y) {
        Vec3 m = this.minecraftEntity.m_20184_();
        this.minecraftEntity.m_20334_(m.f_82479_, y, m.f_82481_);
    }

    public double getMotionZ() {
        return this.minecraftEntity.m_20184_().f_82481_;
    }

    public void setMotionZ(double z) {
        Vec3 m = this.minecraftEntity.m_20184_();
        this.minecraftEntity.m_20334_(m.f_82479_, m.f_82480_, z);
    }

    public void setMotion(double x, double y, double z) {
        this.minecraftEntity.m_20334_(x, y, z);
    }

    public int getTicksExisted() {
        return this.minecraftEntity.f_19797_;
    }

    public void setPosition(BlockContainerJS block) {
        this.setPosition((double)block.getX() + 0.5, (double)block.getY() + 0.05, (double)block.getZ() + 0.5);
    }

    public void setPosition(double x, double y, double z) {
        this.setPositionAndRotation(x, y, z, this.getYaw(), this.getPitch());
    }

    public void setRotation(float yaw, float pitch) {
        this.setPositionAndRotation(this.getX(), this.getY(), this.getZ(), yaw, pitch);
    }

    public void setPositionAndRotation(double x, double y, double z, float yaw, float pitch) {
        this.minecraftEntity.m_7678_(x, y, z, yaw, pitch);
    }

    public void addMotion(double x, double y, double z) {
        this.minecraftEntity.m_20256_(this.minecraftEntity.m_20184_().m_82520_(x, y, z));
    }

    @Override
    public int runCommand(String command) {
        if (this.level instanceof ServerLevelJS) {
            return this.level.getServer().getMinecraftServer().m_129892_().m_82117_(this.minecraftEntity.m_20203_(), command);
        }
        return 0;
    }

    @Override
    public int runCommandSilent(String command) {
        if (this.level instanceof ServerLevelJS) {
            return this.level.getServer().getMinecraftServer().m_129892_().m_82117_(this.minecraftEntity.m_20203_().m_81324_(), command);
        }
        return 0;
    }

    public void kill() {
        this.minecraftEntity.m_6074_();
    }

    public boolean startRiding(EntityJS e, boolean force) {
        return this.minecraftEntity.m_7998_(e.minecraftEntity, force);
    }

    public void removePassengers() {
        this.minecraftEntity.m_20153_();
    }

    public void dismountRidingEntity() {
        this.minecraftEntity.m_8127_();
    }

    public EntityArrayList getPassengers() {
        return new EntityArrayList(this.level, this.minecraftEntity.m_20197_());
    }

    public boolean isPassenger(EntityJS e) {
        return this.minecraftEntity.m_20363_(e.minecraftEntity);
    }

    public EntityArrayList getRecursivePassengers() {
        return new EntityArrayList(this.level, this.minecraftEntity.m_146897_());
    }

    @Nullable
    public EntityJS getRidingEntity() {
        return this.level.getEntity(this.minecraftEntity.m_20202_());
    }

    public String getTeamId() {
        Team team = this.minecraftEntity.m_5647_();
        return team == null ? "" : team.m_5758_();
    }

    public boolean isOnSameTeam(EntityJS e) {
        return this.minecraftEntity.m_7307_(e.minecraftEntity);
    }

    public boolean isOnScoreboardTeam(String teamID) {
        PlayerTeam team = this.minecraftEntity.m_20193_().m_6188_().m_83489_(teamID);
        return team != null && this.minecraftEntity.m_20031_((Team)team);
    }

    public void setCustomName(Component name) {
        this.minecraftEntity.m_6593_(name);
    }

    public Text getCustomName() {
        return Text.of(this.minecraftEntity.m_7770_());
    }

    public boolean getHasCustomName() {
        return this.minecraftEntity.m_8077_();
    }

    public void setCustomNameAlwaysVisible(boolean b) {
        this.minecraftEntity.m_20340_(b);
    }

    public boolean getCustomNameAlwaysVisible() {
        return this.minecraftEntity.m_20151_();
    }

    public Direction getHorizontalFacing() {
        return this.minecraftEntity.m_6350_();
    }

    public Direction getFacing() {
        if (this.getPitch() > 45.0f) {
            return Direction.DOWN;
        }
        if (this.getPitch() < -45.0f) {
            return Direction.UP;
        }
        return this.getHorizontalFacing();
    }

    public float getEyeHeight() {
        return this.minecraftEntity.m_20192_();
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.minecraftEntity.f_19853_, this.minecraftEntity.m_142538_());
    }

    public void setOnFire(int seconds) {
        this.minecraftEntity.m_20254_(seconds);
    }

    public void extinguish() {
        this.minecraftEntity.m_20095_();
    }

    public CompoundTag getFullNBT() {
        CompoundTag nbt = new CompoundTag();
        this.minecraftEntity.m_20240_(nbt);
        return nbt;
    }

    public void setFullNBT(@Nullable CompoundTag nbt) {
        if (nbt != null) {
            this.minecraftEntity.m_20258_(nbt);
        }
    }

    public EntityJS mergeFullNBT(@Nullable CompoundTag tag) {
        if (tag == null || tag.m_128456_()) {
            return this;
        }
        CompoundTag nbt = this.getFullNBT();
        for (String k : tag.m_128431_()) {
            Tag t = tag.m_128423_(k);
            if (t == null || t == EndTag.f_128534_) {
                nbt.m_128473_(k);
                continue;
            }
            nbt.m_128365_(k, tag.m_128423_(k));
        }
        this.setFullNBT(nbt);
        return this;
    }

    @Deprecated
    public CompoundTag getNbt() {
        return this.persistentData;
    }

    public void playSound(SoundEvent id, float volume, float pitch) {
        this.minecraftEntity.f_19853_.m_6263_(null, this.getX(), this.getY(), this.getZ(), id, this.minecraftEntity.m_5720_(), volume, pitch);
    }

    public void playSound(SoundEvent id) {
        this.playSound(id, 1.0f, 1.0f);
    }

    public void spawn() {
        this.level.minecraftLevel.m_7967_(this.minecraftEntity);
    }

    public void attack(String source, float hp) {
        if (damageSourceMap == null) {
            damageSourceMap = new HashMap<String, DamageSource>();
            try {
                for (Field field : DamageSource.class.getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != DamageSource.class) continue;
                    DamageSource s = (DamageSource)field.get(null);
                    damageSourceMap.put(s.m_19385_(), s);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DamageSource s = damageSourceMap.getOrDefault(source, DamageSource.f_19318_);
        this.minecraftEntity.m_6469_(s, hp);
    }

    public void attack(float hp) {
        this.minecraftEntity.m_6469_(DamageSource.f_19318_, hp);
    }

    public RayTraceResultJS rayTrace(double distance) {
        double xRot = this.minecraftEntity.m_146909_();
        double yRot = this.minecraftEntity.m_146908_();
        Vec3 fromPos = this.minecraftEntity.m_20299_(1.0f);
        double x0 = Math.sin(-yRot * (Math.PI / 180) - 3.1415927410125732);
        double z0 = Math.cos(-yRot * (Math.PI / 180) - 3.1415927410125732);
        double y0 = -Math.cos(-xRot * (Math.PI / 180));
        double y = Math.sin(-xRot * (Math.PI / 180));
        double x = x0 * y0;
        double z = z0 * y0;
        Vec3 toPos = fromPos.m_82520_(x * distance, y * distance, z * distance);
        BlockHitResult hitResult = this.minecraftEntity.f_19853_.m_45547_(new ClipContext(fromPos, toPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, this.minecraftEntity));
        return new RayTraceResultJS(this, (HitResult)hitResult, distance);
    }

    public boolean isInWater() {
        return this.minecraftEntity.m_20069_();
    }

    public boolean isUnderWater() {
        return this.minecraftEntity.m_5842_();
    }

    public double getDistanceSq(double x, double y, double z) {
        return this.minecraftEntity.m_20275_(x, y, z);
    }

    public double getDistance(double x, double y, double z) {
        return Math.sqrt(this.getDistanceSq(x, y, z));
    }

    public double getDistanceSq(BlockPos pos) {
        return this.getDistanceSq((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public double getDistance(BlockPos pos) {
        return Math.sqrt(this.getDistanceSq(pos));
    }
}

