/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.entity;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.mods.kubejs.entity.DamageSourceJS;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.entity.EntityPotionEffectsJS;
import dev.latvian.mods.kubejs.entity.RayTraceResultJS;
import dev.latvian.mods.kubejs.entity.forge.LivingEntityJSImpl;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import java.util.function.Consumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LivingEntityJS
extends EntityJS {
    public final LivingEntity minecraftLivingEntity;

    public LivingEntityJS(LevelJS l, LivingEntity e) {
        super(l, (Entity)e);
        this.minecraftLivingEntity = e;
    }

    @Override
    public boolean isLiving() {
        return true;
    }

    public boolean isChild() {
        return this.minecraftLivingEntity.m_6162_();
    }

    public float getHealth() {
        return this.minecraftLivingEntity.m_21223_();
    }

    public void setHealth(float hp) {
        this.minecraftLivingEntity.m_21153_(hp);
    }

    public void heal(float hp) {
        this.minecraftLivingEntity.m_5634_(hp);
    }

    public float getMaxHealth() {
        return this.minecraftLivingEntity.m_21233_();
    }

    public void setMaxHealth(float hp) {
        this.minecraftLivingEntity.m_21051_(Attributes.f_22276_).m_22100_((double)hp);
    }

    public boolean isUndead() {
        return this.minecraftLivingEntity.m_21222_();
    }

    public boolean isOnLadder() {
        return this.minecraftLivingEntity.m_6147_();
    }

    public boolean isSleeping() {
        return this.minecraftLivingEntity.m_5803_();
    }

    public boolean isElytraFlying() {
        return this.minecraftLivingEntity.m_21255_();
    }

    @Nullable
    public LivingEntityJS getRevengeTarget() {
        return this.getLevel().getLivingEntity((Entity)this.minecraftLivingEntity.m_142581_());
    }

    public int getRevengeTimer() {
        return this.minecraftLivingEntity.m_21213_();
    }

    public void setRevengeTarget(@Nullable LivingEntityJS target) {
        this.minecraftLivingEntity.m_6703_(target == null ? null : target.minecraftLivingEntity);
    }

    @Nullable
    public LivingEntityJS getLastAttackedEntity() {
        return this.getLevel().getLivingEntity((Entity)this.minecraftLivingEntity.m_21214_());
    }

    public int getLastAttackedEntityTime() {
        return this.minecraftLivingEntity.m_21215_();
    }

    public int getIdleTime() {
        return this.minecraftLivingEntity.m_21216_();
    }

    public EntityPotionEffectsJS getPotionEffects() {
        return new EntityPotionEffectsJS(this.minecraftLivingEntity);
    }

    @Nullable
    public DamageSourceJS getLastDamageSource() {
        return this.minecraftLivingEntity.m_21225_() == null ? null : new DamageSourceJS(this.getLevel(), this.minecraftLivingEntity.m_21225_());
    }

    @Nullable
    public LivingEntityJS getAttackingEntity() {
        return this.getLevel().getLivingEntity((Entity)this.minecraftLivingEntity.m_21232_());
    }

    public void swingArm(InteractionHand hand) {
        this.minecraftLivingEntity.m_21011_(hand, true);
    }

    public ItemStackJS getEquipment(EquipmentSlot slot) {
        return ItemStackJS.of(this.minecraftLivingEntity.m_6844_(slot));
    }

    public void setEquipment(EquipmentSlot slot, ItemStackJS item) {
        this.minecraftLivingEntity.m_8061_(slot, item.getItemStack());
    }

    public ItemStackJS getHeldItem(InteractionHand hand) {
        return ItemStackJS.of(this.minecraftLivingEntity.m_21120_(hand));
    }

    public void setHeldItem(InteractionHand hand, ItemStackJS item) {
        this.minecraftLivingEntity.m_21008_(hand, item.getItemStack());
    }

    public ItemStackJS getMainHandItem() {
        return this.getEquipment(EquipmentSlot.MAINHAND);
    }

    public void setMainHandItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.MAINHAND, item);
    }

    public ItemStackJS getOffHandItem() {
        return this.getEquipment(EquipmentSlot.OFFHAND);
    }

    public void setOffHandItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.OFFHAND, item);
    }

    public ItemStackJS getHeadArmorItem() {
        return this.getEquipment(EquipmentSlot.HEAD);
    }

    public void setHeadArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.HEAD, item);
    }

    public ItemStackJS getChestArmorItem() {
        return this.getEquipment(EquipmentSlot.CHEST);
    }

    public void setChestArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.CHEST, item);
    }

    public ItemStackJS getLegsArmorItem() {
        return this.getEquipment(EquipmentSlot.LEGS);
    }

    public void setLegsArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.LEGS, item);
    }

    public ItemStackJS getFeetArmorItem() {
        return this.getEquipment(EquipmentSlot.FEET);
    }

    public void setFeetArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.FEET, item);
    }

    public void damageEquipment(EquipmentSlot slot, int amount, Consumer<ItemStackJS> onBroken) {
        ItemStack stack = this.minecraftLivingEntity.m_6844_(slot);
        if (!stack.m_41619_()) {
            stack.m_41622_(amount, this.minecraftLivingEntity, livingEntity -> onBroken.accept(ItemStackJS.of(stack)));
            if (stack.m_41619_()) {
                this.minecraftLivingEntity.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    public void damageEquipment(EquipmentSlot slot, int amount) {
        this.damageEquipment(slot, amount, stack -> {});
    }

    public void damageEquipment(EquipmentSlot slot) {
        this.damageEquipment(slot, 1);
    }

    public void damageHeldItem(InteractionHand hand, int amount, Consumer<ItemStackJS> onBroken) {
        this.damageEquipment(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, amount, onBroken);
    }

    public void damageHeldItem(InteractionHand hand, int amount) {
        this.damageHeldItem(hand, amount, stack -> {});
    }

    public void damageHeldItem() {
        this.damageHeldItem(InteractionHand.MAIN_HAND, 1);
    }

    public boolean isHoldingInAnyHand(Object ingredient) {
        IngredientJS i = IngredientJS.of(ingredient);
        return i.testVanilla(this.minecraftLivingEntity.m_21120_(InteractionHand.MAIN_HAND)) || i.testVanilla(this.minecraftLivingEntity.m_21120_(InteractionHand.OFF_HAND));
    }

    public float getMovementSpeed() {
        return this.minecraftLivingEntity.m_6113_();
    }

    public void setMovementSpeed(float speed) {
        this.minecraftLivingEntity.m_7910_(speed);
    }

    public boolean canEntityBeSeen(LivingEntityJS entity) {
        return BehaviorUtils.m_22667_((LivingEntity)this.minecraftLivingEntity, (LivingEntity)entity.minecraftLivingEntity);
    }

    public float getAbsorptionAmount() {
        return this.minecraftLivingEntity.m_6103_();
    }

    public void setAbsorptionAmount(float amount) {
        this.minecraftLivingEntity.m_7911_(amount);
    }

    public double getReachDistance() {
        return LivingEntityJS.getReachDistance(this.minecraftLivingEntity);
    }

    public RayTraceResultJS rayTrace() {
        return this.rayTrace(this.getReachDistance());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static double getReachDistance(LivingEntity livingEntity) {
        return LivingEntityJSImpl.getReachDistance(livingEntity);
    }
}

